@file:OptIn(ExternalKotlinTargetApi::class)

import org.jetbrains.compose.ExperimentalComposeLibrary
import org.jetbrains.kotlin.gradle.ExternalKotlinTargetApi
import org.jetbrains.kotlin.gradle.dsl.JvmTarget
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryCoordinates
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryDependency
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinClasspath
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinResolvedBinaryDependency
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType
import org.jetbrains.kotlin.gradle.plugin.ide.IdeMultiplatformImport
import org.jetbrains.kotlin.gradle.plugin.ide.IdeMultiplatformImport.DependencyResolutionPhase
import org.jetbrains.kotlin.gradle.plugin.kotlinToolingVersion

plugins {
    alias(libs.plugins.kotlin.multiplatform)
    alias(libs.plugins.compose.compiler)
    alias(libs.plugins.compose.multiplatform)
    alias(libs.plugins.android.kmp.library)
}

kotlin {
    applyDefaultHierarchyTemplate()

    jvm("desktop")
    android {
        namespace = "theorycrafter"
        compileSdk = 36
        minSdk = 26
        androidResources.enable = true
        compilerOptions { jvmTarget.set(JvmTarget.JVM_21) }
    }

    sourceSets {
        val commonMain by getting
        val jvmMain by creating
        val desktopMain by getting
        val androidMain by getting

        jvmMain.dependsOn(commonMain)
        androidMain.dependsOn(jvmMain)
        desktopMain.dependsOn(jvmMain)

        commonMain.dependencies {
            api(compose.runtime)
            api(compose.ui)
            api(compose.foundation)
            api(compose.material)
            api(compose.components.resources)
            api(compose.components.uiToolingPreview)
            api(compose.material)
            api(compose.materialIconsExtended)

            api(":EveData")
            api(":Esi")
            api(":FittingEngine")
            api(":ComposeWidgets")
        }

        commonTest.dependencies {
            implementation(kotlin("test"))
            @OptIn(ExperimentalComposeLibrary::class)
            implementation(compose.uiTest)
        }
    }

    compilerOptions.freeCompilerArgs.apply {
        add("-Xlambdas=indy")
        add("-Xcontext-receivers")
        add("-Xexpect-actual-classes")
    }

}

// The 3 blocks below make IDEA able to resolve the kotlin-stdlib-jvm in the jvmMain source-set
val jvmStdlib: Configuration = project.configurations.create("jvmStdlib") {
    isCanBeResolved = true
    isCanBeConsumed = false
    attributes { attribute(Usage.USAGE_ATTRIBUTE, objects.named(Usage.JAVA_API)) }
    attributes { attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.LIBRARY)) }
    attributes { attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, objects.named(LibraryElements.JAR)) }
    attributes { attribute(KotlinPlatformType.attribute, KotlinPlatformType.jvm) }
}

dependencies {
    jvmStdlib(kotlin("stdlib"))
}

IdeMultiplatformImport.instance(project).registerDependencyResolver(
    resolver = {
        setOf(
            IdeaKotlinResolvedBinaryDependency(
                binaryType = IdeaKotlinBinaryDependency.KOTLIN_COMPILE_BINARY_TYPE,
                classpath = IdeaKotlinClasspath(jvmStdlib.files),
                coordinates = IdeaKotlinBinaryCoordinates(
                    "org.jetbrains.kotlin.fake",
                    "fake-kotlin-stdlib-jvm",
                    project.kotlinToolingVersion.toString()
                )
            )
        )
    },
    constraint = { it.name == "jvmMain" },
    phase = DependencyResolutionPhase.PreDependencyResolution
)

// Makes the (common) Res class public, so it can be used from the other modules
compose.resources {
    publicResClass = true
}

dependencies {
//    androidRuntimeClasspath(libs.compose.ui.tooling)
}

//buildConfig {
//    // BuildConfig configuration here.
//    // https://github.com/gmazzo/gradle-buildconfig-plugin#usage-in-kts
//}
