package theorycrafter.fitting

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue


/**
 * Something that is part of a fit.
 */
interface FitItem {


    /**
     * The fit this item is part of.
     */
    val fit: Fit


}


/**
 * The interface for [FitItem]s that can be disabled in the fitting engine.
 */
interface FitItemWithEnabledState: FitItem {


    /**
     * The item's enabled state.
     */
    val enabledState: EnabledState


    /**
     * Returns whether the item is enabled.
     */
    val enabled: Boolean
        get() = enabledState.value


}


/**
 * A utility for holding the "enabled" state of something as a compose state.
 */
class EnabledState {


    /**
     * The item's enabled state.
     */
    var value by mutableStateOf(true)
        internal set


}
