/**
 * The UI showing a fit's firepower stats: DPS, volley etc.
 */

package theorycrafter.ui.fitstats

import androidx.compose.foundation.layout.Row
import androidx.compose.runtime.Composable
import eve.data.asDamage
import eve.data.asDps
import eve.data.resonanceAsResistancePercentageWithPrecisionAtMost
import theorycrafter.fitting.Fit
import theorycrafter.ui.fiteditor.ValueWithDescription


/**
 * The firepower stats panel.
 */
@Composable
fun FirepowerStats(fit: Fit) {

    @Composable
    fun damageStat(title: String, dps: Double, volley: Double, vararg extraValues: ValueWithDescription?) =
        Stat(
            label = title,
            value = dps.asDps(withUnits = true),
            tooltipValues = buildList {
                add(ValueWithDescription(dps.asDamage(withUnits = false), "damage per second"))
                add(ValueWithDescription(volley.asDamage(withUnits = false), "damage per volley"))
                extraValues.forEach {
                    if (it != null) add(it)
                }
            }
        )

    Row {
        with(fit.firepower) {
            val weaponDps = weaponDps
            val weaponVolley = weaponVolleyDamage
            val droneDps = droneDps
            val droneVolley = droneVolleyDamage
            val weaponDisruptionResonance = fit.electronicWarfare.weaponDisruptionResistance.value

            val weaponDisruptionTooltip = if (weaponDisruptionResonance != 1.0) {
                ValueWithDescription(
                    value = weaponDisruptionResonance.resonanceAsResistancePercentageWithPrecisionAtMost(0),
                    description = "resistance to weapon disruption"
                )
            } else null

            StatsTable(
                columns = 3,
                damageStat(title = "Weapons", dps = weaponDps, volley = weaponVolley, weaponDisruptionTooltip),
                damageStat(title = "Drones", dps = droneDps, volley = droneVolley),
                damageStat(title = "Combined", dps = weaponDps + droneDps, volley = weaponVolley + droneVolley),
            )
        }
    }
}
