package compose.widgets

import androidx.compose.foundation.interaction.MutableInteractionSource
import androidx.compose.material.ExperimentalMaterialApi
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.focus.focusProperties
import androidx.compose.ui.graphics.Color
import compose.utils.ProvideEnabledLocalContentAlpha


/**
 * A button with an icon.
 *
 * This one is more suitable for the desktop than the one in Material.
 */
@OptIn(ExperimentalMaterialApi::class)
@Composable
fun IconButton(
    onClick: () -> Unit,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    focusable: Boolean = false,
    interactionSource: MutableInteractionSource = remember { MutableInteractionSource() },
    content: @Composable () -> Unit
) {
    Surface(
        onClick = onClick,
        enabled = enabled,
        color = Color.Transparent,
        shape = MaterialTheme.shapes.small,
        modifier = modifier
            .focusProperties {
                canFocus = focusable
            },
        interactionSource = interactionSource,
    ) {
        ProvideEnabledLocalContentAlpha(enabled) {
            content()
        }
    }
}