package pro.theorycrafter.android

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.layout.*
import androidx.compose.material.*
import androidx.compose.runtime.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import eve.data.EveData
import kotlin.random.Random


class AppActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContent {
            MaterialTheme(darkColors()) {
                Surface {
                    Box(
                        modifier = Modifier.fillMaxSize(),
                        contentAlignment = Alignment.Center
                    ) {
                        val eveData by produceState<EveData?>(null) {
                            value = EveData.loadStandard()
                        }
                        var seed by remember { mutableLongStateOf(Random.nextLong()) }
                        val shipTypes by produceState(emptyList(), eveData, seed) {
                            val eveData = eveData
                            value = if (eveData == null) emptyList() else List(3) { eveData.shipTypes.random() }
                        }

                        Column(
                            modifier = Modifier.padding(24.dp).width(IntrinsicSize.Max),
                            verticalArrangement = Arrangement.spacedBy(8.dp)
                        ) {
                            for (shipType in shipTypes) {
                                Row(
//                                    modifier = Modifier.fillMaxWidth(),
                                    horizontalArrangement = Arrangement.spacedBy(8.dp),
                                    verticalAlignment = Alignment.CenterVertically
                                ) {
                                    Icons.EveItemType(shipType)
                                    Text("${shipType.name} has ${shipType.fitting.slots.med} med slots")
                                }
                            }

                            Button(
                                onClick = { seed = Random.nextLong() },
                                modifier = Modifier.align(Alignment.CenterHorizontally)
                            ) {
                                Text("Refresh")
                            }
                        }
                    }
                }
            }
//            App(onThemeChanged = { ThemeChanged(it) })
        }
    }
}

//@Composable
//private fun ThemeChanged(isDark: Boolean) {
//    val view = LocalView.current
//    LaunchedEffect(isDark) {
//        val window = (view.context as Activity).window
//        WindowInsetsControllerCompat(window, window.decorView).apply {
//            isAppearanceLightStatusBars = isDark
//            isAppearanceLightNavigationBars = isDark
//        }
//    }
//}

