package theorycrafter.ui.tournaments

import androidx.compose.ui.test.hasTestTag
import theorycrafter.TestTags

/**
 * Matchers for various nodes in the fit editor window.
 */
object TournamentNodes {


    /**
     * Matchers for nodes in the compositions list.
     */
    object CompsList {

        /**
         * The matcher for the "New Composition" button in the compositions list.
         */
        val NewCompositionButton = hasTestTag(TestTags.CompsList.NewCompositionButton)

    }


    /**
     * Matchers for nodes in the compositions editor.
     */
    object CompEditor {


        /**
         * The matcher for the root node in the composition editor.
         */
        val RootNode = hasTestTag(TestTags.CompEditor.RootNode)


    }



}