package theorycrafter.ui

import androidx.compose.ui.test.ExperimentalTestApi
import androidx.compose.ui.test.assertIsFocused
import androidx.compose.ui.test.hasTestTag
import androidx.compose.ui.test.onNodeWithTag
import theorycrafter.*
import theorycrafter.TheorycrafterContext.eveData
import kotlin.test.Test


/**
 * Various UI tests.
 */
@OptIn(ExperimentalTestApi::class)
class FitListTest: TheorycrafterTest() {


    /**
     * Verify that the initial focus is on the fit search field.
     */
    @Test
    fun initialFocusIsOnFitSearch() = runBlockingTest {
        rule.setApplicationContent {
            MainWindowContent()
        }
        rule.onNodeWithTag(TestTags.FitList.SearchField).assertIsFocused()
    }


    /**
     * Verify that the initial focus is on the fit search field, even when there's a fit displayed in the fit editor
     * at startup.
     */
    @Test
    fun initialFocusIsOnFitSearchWhenFitIsInitiallyOpen() = runBlockingTest {
        val fitHandle = TheorycrafterContext.fits.addEmpty(eveData.shipType("Caracal"), "Test")
        TheorycrafterContext.settings.mainWindow.fitHandle = fitHandle
        rule.setApplicationContent {
            MainWindowContent()
        }

        // Wait for the fit editor to display the fit
        rule.waitUntilNodeCount(hasTestTag(TestTags.FitEditor.TitleFitName), 1)

        // Assert the search field is focused
        rule.onNodeWithTag(TestTags.FitList.SearchField).assertIsFocused()
    }


}