package theorycrafter.utils

import androidx.compose.runtime.State


/**
 * An immutable [State].
 */
data class ImmutableState<T>(override val value: T): State<T>


/**
 * Returns an immutable [State] that will always return the given value.
 */
fun <T> immutableStateOf(value: T): State<T> = ImmutableState(value)
