package theorycrafter.ui.widgets

import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.selection.selectable
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import compose.utils.ProvideEnabledLocalContentAlpha
import compose.utils.VerticallyCenteredRow
import compose.widgets.SingleLineText
import theorycrafter.ui.RadioButton
import theorycrafter.ui.TheorycrafterTheme


/**
 * Radio button and custom content to the right.
 */
@Composable
fun RadioButtonRow(
    selected: Boolean,
    onClick: () -> Unit,
    enabled: Boolean = true,
    modifier: Modifier = Modifier,
    content: @Composable RowScope.() -> Unit
) {
    ProvideEnabledLocalContentAlpha(enabled) {
        VerticallyCenteredRow(
            modifier = modifier
                .clip(MaterialTheme.shapes.small)
                .selectable(
                    selected = selected,
                    onClick = onClick,
                    enabled = enabled
                )
                .padding(
                    start = TheorycrafterTheme.spacing.xxxsmall,
                    end = TheorycrafterTheme.spacing.xsmall  // The icon typically has some padding already
                ),
        ) {
            TheorycrafterTheme.RadioButton(
                selected = selected,
                onClick = null,
                enabled = enabled,
            )
            content()
        }
    }
}


/**
 * Radio button with text to the right that.
 */
@Composable
fun RadioButtonWithText(
    text: String,
    selected: Boolean,
    onClick: () -> Unit,
    enabled: Boolean = true,
    modifier: Modifier = Modifier,
) {
    RadioButtonRow(
        selected = selected,
        onClick = onClick,
        enabled = enabled,
        modifier = modifier
    ) {
        TextNearRadioButton(text)
    }
}


/**
 * The text to the right of a radio button.
 */
@Composable
private fun TextNearRadioButton(text: String) {
    SingleLineText(
        text = text,
        modifier = Modifier
            .padding(vertical = TheorycrafterTheme.spacing.xxsmall)
    )
}
