package theorycrafter.ui.widgets

import androidx.compose.animation.core.animateFloatAsState
import androidx.compose.material.Icon
import androidx.compose.material.icons.outlined.KeyboardArrowDown
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.graphicsLayer
import compose.utils.VerticallyCenteredRow
import theorycrafter.ui.TheorycrafterTheme

/**
 * A label that reveals/hides content below it.
 */
@Composable
fun Disclosure(
    modifier: Modifier = Modifier,
    label: @Composable () -> Unit,
    content: @Composable () -> Unit
) {
    compose.widgets.Disclosure(
        modifier = modifier,
        label = { expanded ->
            VerticallyCenteredRow {
                val angle by animateFloatAsState(if (expanded) 0f else -90f)
                Icon(
                    imageVector = TheorycrafterTheme.iconStyle.KeyboardArrowDown,
                    contentDescription = "Arrow icon for disclosure",
                    modifier = Modifier.graphicsLayer(rotationZ = angle)
                )
                label()
            }
        },
        content = content
    )
}
