package theorycrafter

import androidx.compose.runtime.Stable
import eve.data.ModuleSlotType
import eve.data.SubsystemType


/**
 * The names of test tags for UI nodes tests want to access.
 */
object TestTags {


    /**
     * The test tags for the fit list.
     */
    object FitList {


        /**
        * The fit list itself.
         */
        const val FitList = "fit-list"


        /**
         * The fits search field.
         */
        const val SearchField = "fit-search-field"


        /**
        * The fit item in the list.
         */
        object Item {


            /**
             * The fit list item itself.
             */
            const val Item = "fit-item"


            /**
            * The name of the fit.
             */
            const val FitName = "fit-item-fit-name"


        }


    }


    /**
     * The test tags for the fit editor.
     */
    object FitEditor {


        /**
         * The fit editor title.
         */
        const val TitleFitName = "fit-editor-title"


        /**
         * The node in the fit editor to which key events not specific to a slot can be sent.
         */
        const val KeyEventsReceiver = "fit-editor-key-events-receiver"


        /**
        * The test tag for the tactical mode slot.
         */
        const val TacticalModeSlot = "tactical-mode-slot"


        /**
         * The test tag for the subsystem row of the given kind.
         */
        @Stable
        fun subsystemRow(subsystemKind: SubsystemType.Kind) = when (subsystemKind) {
            SubsystemType.Kind.CORE -> "subsystem-row-core"
            SubsystemType.Kind.DEFENSIVE -> "subsystem-row-defensive"
            SubsystemType.Kind.OFFENSIVE -> "subsystem-row-offensive"
            SubsystemType.Kind.PROPULSION -> "subsystem-row-propulsion"
        }


        /**
         * The test tag for the module row of the given slot type, at the given index inside its section.
         */
        @Stable
        fun moduleRow(slotType: ModuleSlotType, index: Int) = buildString {
            append("module-")
            append(slotType.name.lowercase())
            append("-row#")
            append(index.toString())
        }


        /**
         * The test tag for the charge row of the given slot type, for the module with given index inside its section.
         */
        @Stable
        fun chargeRow(slotType: ModuleSlotType, index: Int) = buildString {
            append("charge-")
            append(slotType.name.lowercase())
            append("-row#")
            append(index.toString())
        }


        /**
         * The test tag for the drone row at the given index inside its section.
         */
        @Stable
        fun droneRow(index: Int) = "drone-row#$index"


        /**
         * The test tag for the empty drone row.
         */
        const val EmptyDroneRow = "drone-row-empty"


        /**
         * The test tag for the cargohold row at the given index inside its section.
         */
        @Stable
        fun cargoholdRow(index: Int) = "cargohold-row#$index"


        /**
         * The test tag for the empty cargohold row.
         */
        @Stable
        const val EmptyCargoholdRow = "cargohold-row-empty"


        /**
         * The test tag for the implant row at the given index inside its section.
         */
        @Stable
        fun implantRow(index: Int) = "implant-row#$index"


        /**
         * The test tag for the empty implant row.
         */
        const val EmptyImplantRow = "implant-row-empty"


        /**
         * The test tag for the booster row at the given index inside its section.
         */
        @Stable
        fun boosterRow(index: Int) = "booster-row#$index"


        /**
         * The test tag for the empty booster row.
         */
        const val EmptyBoosterRow = "booster-row-empty"


        /**
         * The test tag for the command effect row at the given index inside its section.
         */
        @Stable
        fun commandEffectRow(index: Int) = "command-effect-row#$index"


        /**
         * The test tag for the affecting module of a command effect.
         */
        @Stable
        fun commandEffectAffectingModuleRow(effectIndex: Int, moduleRowIndex: Int) =
            commandEffectRow(effectIndex) + "-module#$moduleRowIndex"


        /**
         * The test tag for the charge of an affecting module of a command effect.
         */
        @Stable
        fun commandEffectAffectingModuleChargeRow(effectIndex: Int, moduleRowIndex: Int) =
            commandEffectRow(effectIndex) + "-module-charge#$moduleRowIndex"


        /**
        * The test tag for the empty command effect row.
         */
        const val EmptyCommandEffectRow = "command-effect-row-empty"


        /**
         * The test tag for the hostile effect row at the given index inside its section.
         */
        @Stable
        fun hostileEffectRow(index: Int) = "hostile-effect-row#$index"


        /**
         * The test tag for the affecting module of a hostile effect.
         */
        @Stable
        fun hostileEffectAffectingModuleRow(effectIndex: Int, moduleRowIndex: Int) =
            hostileEffectRow(effectIndex) + "-module#$moduleRowIndex"


        /**
         * The test tag for the charge of an affecting module of a hostile effect.
         */
        @Stable
        fun hostileEffectAffectingModuleChargeRow(effectIndex: Int, moduleRowIndex: Int) =
            hostileEffectRow(effectIndex) + "-module-charge#$moduleRowIndex"


        /**
         * The test tag for the affecting drone of a hostile effect.
         */
        @Stable
        fun hostileEffectAffectingDroneRow(effectIndex: Int, droneRowIndex: Int) =
            hostileEffectRow(effectIndex) + "-drone#$droneRowIndex"


        /**
         * The test tag for a hostile module effect.
         */
        @Stable
        fun hostileModuleEffectRow(moduleRowIndex: Int) = "hostile-module-effect-row#$moduleRowIndex"


        /**
         * The test tag for the charge of a hostile module effect.
         */
        @Stable
        fun hostileModuleEffectChargeRow(moduleRowIndex: Int) = "hostile-module-effect-charge-row#$moduleRowIndex"


        /**
         * The test tag for a hostile drone effect.
         */
        @Stable
        fun hostileDroneEffectRow(droneRowIndex: Int) = "hostile-drone-effect-row#$droneRowIndex"


        /**
        * The test tag for the empty hostile effect row.
         */
        const val EmptyHostileEffectRow = "hostile-effect-row-empty"


        /**
         * The test tag for the friendly effect row at the given index inside its section.
         */
        @Stable
        fun friendlyEffectRow(index: Int) = "friendly-effect-row#$index"


        /**
         * The test tag for the affecting module of a friendly effect.
         */
        @Stable
        fun friendlyEffectAffectingModuleRow(effectIndex: Int, moduleRowIndex: Int) =
            friendlyEffectRow(effectIndex) + "-module#$moduleRowIndex"


        /**
         * The test tag for the charge of an affecting module of a friendly effect.
         */
        @Stable
        fun friendlyEffectAffectingModuleChargeRow(effectIndex: Int, moduleRowIndex: Int) =
            friendlyEffectRow(effectIndex) + "-module-charge#$moduleRowIndex"


        /**
         * The test tag for the affecting drone of a friendly effect.
         */
        @Stable
        fun friendlyEffectAffectingDroneRow(effectIndex: Int, droneRowIndex: Int) =
            friendlyEffectRow(effectIndex) + "-drone#$droneRowIndex"


        /**
         * The test tag for a friendly module effect.
         */
        @Stable
        fun friendlyModuleEffectRow(moduleRowIndex: Int) = "friendly-module-effect-row#$moduleRowIndex"


        /**
         * The test tag for the charge of a friendly module effect.
         */
        @Stable
        fun friendlyModuleEffectChargeRow(moduleRowIndex: Int) = "friendly-module-effect-charge-row#$moduleRowIndex"


        /**
         * The test tag for a friendly drone effect.
         */
        @Stable
        fun friendlyDroneEffectRow(droneRowIndex: Int) = "friendly-drone-effect-row#$droneRowIndex"


        /**
         * The test tag for the empty friendly effect row.
         */
        const val EmptyFriendlyEffectRow = "friendly-effect-row-empty"


        /**
         * The test tag for the incoming damage row at the given index inside its section.
         */
        @Stable
        fun incomingDamageRow(slotIndex: Int) = "incoming-damage-row#$slotIndex"


        /**
         * The test tag for the empty incoming damage row.
         */
        @Stable
        const val EmptyIncomingDamageRow = "incoming-damage-row-empty"


        /**
         * The test tag for the environment row at the given index inside its section.
         */
        @Stable
        fun environmentRow(slotIndex: Int) = "environment-row#$slotIndex"


        /**
         * The test tag for the empty environment row.
         */
        @Stable
        const val EmptyEnvironmentRow = "environment-row-empty"


    }


    /**
     * The test tags for the tournament compositions list.
     */
    object CompsList {


        /**
         * The test tag for the "New Composition" button.
         */
        const val NewCompositionButton = "new-comp-button"


    }


    /**
     * The test tags for the composition editor.
     */
    object CompEditor {


        /**
         * The root node in the fit editor.
         */
        const val RootNode = "comp-editor-root"


    }


}