package theorycrafter.fitting

import androidx.compose.runtime.Stable
import eve.data.Attributes
import eve.data.WarfareBuffsType


/**
 * An instance of the synthetic Warfare Buffs type.
 */
@Stable
class WarfareBuffs internal constructor(


    /**
     * The context [Attributes].
     */
    attributes: Attributes,


    /**
     * The type.
     */
    type: WarfareBuffsType


) : EveItem<WarfareBuffsType>(attributes, type), FitItem {


    /**
     * The fit this [WarfareBuffs] is part of.
     */
    override lateinit var fit: Fit
        internal set


    /**
     * The property for the bonus to shield resistances.
     */
    val warfareShieldResonanceBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.shieldResonanceBonus)


    /**
     * The property for the bonus to shield boosters.
     */
    val warfareShieldBoostersBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.shieldBoostersBonus)


    /**
     * The property for the bonus to shield hitpoints.
     */
    val warfareShieldHitpointsBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.shieldHitpointsBonus)


    /**
     * The property for the bonus to armor resistances.
     */
    val warfareArmorResonanceBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.armorResonanceBonus)


    /**
     * The property for the bonus to armor repairers.
     */
    val warfareArmorRepairersBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.armorRepairersBonus)


    /**
     * The property for the bonus to armor hitpoints.
     */
    val warfareArmorHitpointsBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.armorHitpointsBonus)


    /**
     * The property for the bonus to scan resolution.
     */
    val warfareScanResolutionBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.scanResolutionBonus)


    /**
     * The property for the bonus to ewar.
     */
    val warfareElectronicSuperiorityBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.electronicSuperiorityBonus)


    /**
     * The property for the bonus to sensor strength.
     */
    val warfareSensorStrengthBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.sensorStrengthBonus)


    /**
     * The property for the bonus to ewar resistance.
     */
    val warfareEwarResistance: AttributeProperty<Double>
        get() = property(attributes.warfare.ewarResistance)


    /**
     * The property for the bonus to signature radius.
     */
    val warfareSignatureRadiusBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.signatureRadiusBonus)


    /**
     * The property for the bonus to warp scrambler/disruptor and webifier range.
     */
    val warfareTackleRangeBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.tackleRangeBonus)


    /**
     * The property for the bonus to propulsion module speed factor.
     */
    val warfareSpeedFactorBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.speedFactorBonus)


    /**
     * The property for the bonus to targeting range.
     */
    val warfareTargetingRangeBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.targetingRangeBonus)


    /**
     * The property for the bonus to agility.
     */
    val warfareAgilityBonus: AttributeProperty<Double>
        get() = property(attributes.warfare.agilityBonus)


}
