package eve.data

import java.util.*

/**
 * The interface for an Eve object that has an associated icon.
 */
interface EveObjectWithIcon {

    /**
     * Returns whether the object actually has an icon.
     */
    val hasIcon: Boolean

    /**
     * Returns the resource path of this item type's icon; `null` if the object doesn't actually have an icon.
     */
    fun iconResourcePath(): String?

    /**
     * Loads and returns the byte array for this item type's icon.
     *
     * @return The byte array for the icon's image, or `null` if this type has no icon.
     * @throws [MissingResourceException] if the icon can't be found.
     */
    fun loadIconBytes(): ByteArray? {
        val resourcePath = iconResourcePath() ?: return null
        val stream = javaClass.getResourceAsStream(resourcePath) ?:
            throw MissingResourceException("Image for icon of $this not found", javaClass.name, resourcePath)
        return stream.use { it.readBytes() }
    }

}
