import org.jetbrains.compose.ExperimentalComposeLibrary

buildscript {
    repositories {
        google()
        gradlePluginPortal()
        maven("https://maven.pkg.jetbrains.space/public/p/compose/dev")
    }
}

plugins {
    kotlin("jvm") version "2.0.20"
    id("org.jetbrains.kotlin.plugin.compose") version "2.0.20"
    id("org.jetbrains.compose") version "1.9.3"
}

repositories {
    google()
    mavenCentral()
    maven("https://maven.pkg.jetbrains.space/public/p/compose/dev")
    maven("https://plugins.gradle.org/m2/")
}

dependencies {
    implementation(compose.desktop.currentOs)
    implementation(compose.materialIconsExtended)

    @OptIn(ExperimentalComposeLibrary::class)
    testImplementation(compose.uiTest)
    testImplementation(kotlin("test", version = "2.0.20"))
}

kotlin {
    jvmToolchain(17)
}

// Prevents the Java icon from being shown in the macOS dock when running tests
tasks.withType<Test>().configureEach {
    systemProperty("apple.awt.UIElement", "true")
}
