package theorycrafter.ui.fiteditor

import androidx.compose.ui.input.key.Key


/**
 * The keys we use on fit editor slots.
 *
 * This should correspond to [FitEditorKeyShortcuts].
 */
object FitEditorSlotKeys {


    /**
     * The key to select the previous item in a carousel.
     */
    val CarouselPrev = Key.DirectionLeft


    /**
     * The key to select the next item in a carousel.
     */
    val CarouselNext = Key.DirectionRight


    /**
     * The key to start editing a slot.
     */
    val StartEditingSlot = Key.Enter


    /**
     * The key to finish editing a slot.
     */
    val FinishEditingSlot = Key.Enter


    /**
     * The key to clear a slot.
     */
    val ClearSlot = Key.Delete


    /**
     * The key to toggle an item's primary state in a carousel.
     */
    val ToggleItemPrimary = Key.T


    /**
     * The key to toggle an item's online state in a carousel.
     */
    val ToggleItemOnline = Key.O


    /**
     * The key to toggle an item's overheated state in a carousel.
     */
    val ToggleItemOverheated = Key.H


    /**
     * The key to add an item of the same type as the selected one.
     */
    val AddOneItem = Key.Plus


    /**
     * The key to remove an item of the same type as the selected one.
     */
    val RemoveOneItem = Key.Minus


}