package theorycrafter

import kotlin.test.Test
import kotlin.test.assertEquals

/**
 * Tests the fit search.
 */
class FitSearchTest: TheorycrafterTest() {


    /**
     * Verifies that searching for a substring that appears in parentheses finds the fit.
     */
    @Test
    fun findsFitsInParentheses() = runBlockingTest {
        val shipType = TheorycrafterContext.eveData.shipType("Caracal")
        val fit = TheorycrafterContext.fits.addEmpty(shipType, "MyCaracal (HAM)")
        assertEquals(fit, TheorycrafterContext.queryFits("HAM")!!.first())
    }


    /**
     * Verifies that searching for a substring that appears after a comma finds the fit.
     */
    @Test
    fun findsFitsAfterComma() = runBlockingTest {
        val shipType = TheorycrafterContext.eveData.shipType("Caracal")
        val fit = TheorycrafterContext.fits.addEmpty(shipType, "MyCaracal,HAM")
        assertEquals(fit, TheorycrafterContext.queryFits("HAM")!!.first())
    }


    /**
     * Verifies that searching for a substring that appears after a dash finds the fit.
     */
    @Test
    fun findsFitsAfterDash() = runBlockingTest {
        val shipType = TheorycrafterContext.eveData.shipType("Caracal")
        val fit = TheorycrafterContext.fits.addEmpty(shipType, "MyCaracal-HAM")
        assertEquals(fit, TheorycrafterContext.queryFits("HAM")!!.first())
    }


    /**
     * Verifies that searching for a fit tag finds the fit.
     */
    @Test
    fun findsFitsExactTag() = runBlockingTest {
        val shipType = TheorycrafterContext.eveData.shipType("Caracal")
        val fit = TheorycrafterContext.fits.addEmpty(shipType, "MyCaracal-HAM", tags = listOf("test_tag"))
        assertEquals(fit, TheorycrafterContext.queryFits("#test_tag")!!.first())
    }


    /**
     * Verifies that searching for the prefix of a fit tag finds the fit.
     */
    @Test
    fun findsFitsTagPrefix() = runBlockingTest {
        val shipType = TheorycrafterContext.eveData.shipType("Caracal")
        val fit = TheorycrafterContext.fits.addEmpty(shipType, "MyCaracal-HAM", tags = listOf("test_tag"))
        assertEquals(fit, TheorycrafterContext.queryFits("#test")!!.first())
    }


}