/**
 * Utilities related to profiling and measuring run times.
 */

package theorycrafter.utils

import kotlin.time.DurationUnit
import kotlin.time.measureTimedValue


/**
 * Runs the given block and prints how long it took.
 */
inline fun <T> timeAction(
    actionName: String,
    unit: DurationUnit = DurationUnit.MILLISECONDS,
    decimals: Int = 0,
    block: () -> T
) = measureTimedValue {
    block()
}.let {
    println("$actionName took ${it.duration.toString(unit, decimals)}")
    it.value
}
