package theorycrafter.ui.widgets

import androidx.compose.foundation.ExperimentalFoundationApi
import androidx.compose.foundation.onClick
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.PointerIcon
import androidx.compose.ui.input.pointer.pointerHoverIcon
import androidx.compose.ui.platform.LocalUriHandler
import androidx.compose.ui.text.TextStyle
import theorycrafter.ui.TheorycrafterTheme


/**
 * Simple clickable text.
 */
@OptIn(ExperimentalFoundationApi::class)
@Composable
fun ClickableText(
    text: String,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
    onClick: () -> Unit
) {
    Text(
        text = text,
        style = TextStyle(
            color = TheorycrafterTheme.colors.primary(enabled = enabled),
        ),
        modifier = modifier
            .onClick(enabled = enabled, onClick = onClick)
            .pointerHoverIcon(PointerIcon.Hand)
    )
}


/**
 * A clickable text that opens a URL.
 */
@Composable
fun UrlText(
    text: String,
    url: String,
    modifier: Modifier = Modifier,
    enabled: Boolean = true,
) {
    val uriHandler = LocalUriHandler.current
    ClickableText(
        text = text,
        enabled = enabled,
        onClick = { uriHandler.openUri(url) }
    )
}