/**
 * A small, two-column table, useful for fit editor tooltips.
 */

package theorycrafter.ui.fiteditor

import androidx.compose.foundation.layout.*
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import theorycrafter.ui.TheorycrafterTheme


/**
 * A value and a short description.
 */
data class ValueWithDescription(val value: String, val description: String)


/**
 * A table displaying a list of [ValueWithDescription] objects.
 */
@Composable
fun ValueWithDescriptionTable(
    items: List<ValueWithDescription>,
    modifier: Modifier = Modifier,
    padding: PaddingValues = PaddingValues(0.dp),
){
    val horizontalInterCellPadding = TheorycrafterTheme.spacing.xxsmall
    val verticalInterCellPadding = TheorycrafterTheme.spacing.xxxsmall
    Row(
        modifier = modifier
            .padding(padding),
        horizontalArrangement = Arrangement.spacedBy(horizontalInterCellPadding)
    ) {
        Column(
            modifier = Modifier.width(IntrinsicSize.Max),
            verticalArrangement = Arrangement.spacedBy(verticalInterCellPadding)
        ) {
            for (item in items){
                Text(
                    text = item.value,
                    modifier = Modifier.fillMaxWidth(),
                    textAlign = TextAlign.End
                )
            }
        }
        Column(
            modifier = Modifier.width(IntrinsicSize.Max),
            verticalArrangement = Arrangement.spacedBy(verticalInterCellPadding)
        ) {
            for (item in items){
                Text(
                    text = item.description,
                    modifier = Modifier.fillMaxWidth(),
                    textAlign = TextAlign.Start
                )
            }
        }
    }
}


/**
 * A table displaying a list of [ValueWithDescription] objects.
 */
@Composable
fun ValueWithDescriptionTable(
    vararg items: ValueWithDescription,
    modifier: Modifier = Modifier,
    padding: PaddingValues = PaddingValues(0.dp),
) {
    ValueWithDescriptionTable(
        items = items.asList(),
        modifier = modifier,
        padding = padding
    )
}
