package theorycrafter.fitting

import androidx.compose.runtime.Stable
import eve.data.Attributes
import eve.data.ImplantType


/**
 * An instance of an implant.
 */
@Stable
class Implant internal constructor(


    /**
     * The fit this implant is part of.
     */
    override val fit: Fit,


    /**
     * The context [Attributes].
     */
    attributes: Attributes,


    /**
     * The implant type.
     */
    type: ImplantType,


) : EveItem<ImplantType>(attributes, type), FitItemWithEnabledState {


    override val enabledState = EnabledState()


}
