package theorycrafter.fitting

import androidx.compose.runtime.Stable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import eve.data.CharacterType
import eve.data.EveData


/**
 * An instance of an eve character.
 */
@Stable
class Character internal constructor(


    /**
     * The context [EveData].
     */
    eveData: EveData,


    /**
     * The initial skill set of this character.
     */
    skillSet: SkillSet


) : EveItem<CharacterType>(eveData.attributes, eveData.characterType), FitItem {


    /**
     * The skill set of this character.
     */
    var skillSet: SkillSet by mutableStateOf(skillSet)
        internal set


    /**
     * The fit this [Character] is part of.
     */
    override lateinit var fit: Fit
        internal set


    /**
     * The maximum number of targets that can be locked by this character.
     */
    val maxLockedTargets: AttributeProperty<Int>
        get() = property(attributes.maxLockedTargets)


    /**
     * The missile damage multiplier.
     */
    val missileDamageMultiplier: AttributeProperty<Double>
        get() = property(attributes.missileDamageMultiplier)


    /**
     * The maximum number of active drones that can be used by this character.
     */
    val maxActiveDrones: AttributeProperty<Int>
        get() = property(attributes.maxActiveDrones)


}