/**
 * Methods for identifying subsystems.
 */

package eve.data.typeid

import eve.data.SubsystemType


/**
 * Returns whether the subsystem is an Augmented Antimatter Reactor.
 */
fun SubsystemType.isAugmentedAntimatterReactor() = name.endsWith("Augmented Antimatter Reactor")


/**
 * Returns whether the subsystem is a "Dissolution Sequencer".
 */
fun SubsystemType.isDissolutionSequencer() = name.endsWith("Dissolution Sequencer")


/**
 * Returns whether the subsystem is an "Energy Parasitic Complex".
 */
fun SubsystemType.isEnergyParasiticComplex() = name.endsWith("Energy Parasitic Complex")


/**
 * Returns whether the subsystem is an "Augmented Plating".
 */
fun SubsystemType.isAugmentedPlating() = name.endsWith("Augmented Plating")


/**
 * Returns whether the subsystem is a "Covert Reconfiguration".
 */
fun SubsystemType.isCovertReconfiguration() = name.endsWith("Covert Reconfiguration")


/**
 * Returns whether the subsystem is a "Nanobot Injector".
 */
fun SubsystemType.isNanobotInjector() = name.endsWith("Nanobot Injector")


/**
 * Returns whether the subsystem is an "Assault Optimization".
 */
fun SubsystemType.isAssaultOptimization() = name.endsWith("Assault Optimization")


/**
 * Returns whether the subsystem is a "Liquid Crystal Magnifiers".
 */
fun SubsystemType.isLiquidCrystalMagnifiers() = name.endsWith("Liquid Crystal Magnifiers")


/**
 * Returns whether the subsystem is a "Support Processor".
 */
fun SubsystemType.isSupportProcessor() = name.endsWith("Support Processor")


/**
 * Returns whether the subsystem is an "Intercalated Nanofibers".
 */
fun SubsystemType.isIntercalatedNanofibers() = name.endsWith("Intercalated Nanofibers")


/**
 * Returns whether the subsystem is an "Interdiction Nullifier".
 */
fun SubsystemType.isInterdictionNullifier() = name.endsWith("Interdiction Nullifier")


/**
 * Returns whether the subsystem is a "Wake Limiter".
 */
fun SubsystemType.isWakeLimiter() = name.endsWith("Wake Limiter")


/**
 * Returns whether the subsystem is an "Augmented Graviton Reactor".
 */
fun SubsystemType.isAugmentedGravitonReactor() = name.endsWith("Augmented Graviton Reactor")


/**
 * Returns whether the subsystem is an "Electronic Efficiency Gate".
 */
fun SubsystemType.isElectronicEfficiencyGate() = name.endsWith("Electronic Efficiency Gate")


/**
 * Returns whether the subsystem is an "Obfuscation Manifold".
 */
fun SubsystemType.isObfuscationManifold() = name.endsWith("Obfuscation Manifold")


/**
 * Returns whether the subsystem is an "Amplification Node".
 */
fun SubsystemType.isAmplificationNode() = name.endsWith("Amplification Node")


/**
 * Returns whether the subsystem is a "Supplemental Screening".
 */
fun SubsystemType.isSupplementalScreening() = name.endsWith("Supplemental Screening")


/**
 * Returns whether the subsystem is an "Accelerated Ejection Bay".
 */
fun SubsystemType.isAcceleratedEjectionBay() = name.endsWith("Accelerated Ejection Bay")


/**
 * Returns whether the subsystem is a "Magnetic Infusion Basin".
 */
fun SubsystemType.isMagneticInfusionBasin() = name.endsWith("Magnetic Infusion Basin")


/**
 * Returns whether the subsystem is a "Chassis Optimization".
 */
fun SubsystemType.isChassisOptimization() = name.endsWith("Chassis Optimization")


/**
 * Returns whether the subsystem is a "Fuel Catalyst".
 */
fun SubsystemType.isFuelCatalyst() = name.endsWith("Fuel Catalyst")


/**
 * Returns whether the subsystem is an "Augmented Fusion Reactor".
 */
fun SubsystemType.isAugmentedFusionReactor() = name.endsWith("Augmented Fusion Reactor")


/**
 * Returns whether the subsystem is a "Friction Extension Processor".
 */
fun SubsystemType.isFrictionExtensionProcessor() = name.endsWith("Friction Extension Processor")


/**
 * Returns whether the subsystem is a "Drone Synthesis Projector".
 */
fun SubsystemType.isDroneSynthesisProjector() = name.endsWith("Drone Synthesis Projector")


/**
 * Returns whether the subsystem is a "Hybrid Encoding Platform".
 */
fun SubsystemType.isHybridEncodingPlatform() = name.endsWith("Hybrid Encoding Platform")


/**
 * Returns whether the subsystem is a "Hyperspatial Optimization".
 */
fun SubsystemType.isHyperspatialOptimization() = name.endsWith("Hyperspatial Optimization")


/**
 * Returns whether the subsystem is a "Localized Injectors".
 */
fun SubsystemType.isLocalizedInjectors() = name.endsWith("Localized Injectors")


/**
 * Returns whether the subsystem is an "Augmented Nuclear Reactor".
 */
fun SubsystemType.isAugmentedNuclearReactor() = name.endsWith("Augmented Nuclear Reactor")



/**
 * Returns whether the subsystem is an "Immobility Drivers".
 */
fun SubsystemType.isImmobilityDrivers() = name.endsWith("Immobility Drivers")


/**
 * Returns whether the subsystem is an "Adaptive Defense Node".
 */
fun SubsystemType.isAdaptiveDefenseNode() = name.endsWith("Adaptive Defense Node")


/**
 * Returns whether the subsystem is an "Augmented Durability".
 */
fun SubsystemType.isAugmentedDurability() = name.endsWith("Augmented Durability")


/**
 * Returns whether the subsystem is a "Launcher Efficiency Configuration".
 */
fun SubsystemType.isLauncherEfficiencyConfiguration() = name.endsWith("Launcher Efficiency Configuration")


/**
 * Returns whether the given subsystem is a "Projectile Scoping Array".
 */
fun SubsystemType.isProjectileScopingArray() = name.endsWith("Projectile Scoping Array")
