package theorycrafter.utils

import java.io.OutputStream


/**
 * Writes the data into two target streams.
 */
class TeeOutputStream(
    private val first: OutputStream,
    private val second: OutputStream
): OutputStream() {

    override fun close() {
        @Suppress("ConvertTryFinallyToUseCall")
        try {
            first.close()
        } finally {
            second.close()
        }
    }

    override fun flush() {
        try {
            first.flush()
        } finally {
            second.flush()
        }
    }

    override fun write(b: Int) {
        try {
            first.write(b)
        } finally {
            second.write(b)
        }
    }

    override fun write(b: ByteArray, off: Int, len: Int) {
        try {
            first.write(b, off, len)
        } finally {
            second.write(b, off, len)
        }
    }

}