package theorycrafter

import org.jetbrains.skiko.OS
import org.jetbrains.skiko.hostOs
import java.io.File
import java.io.IOException
import java.util.*


/**
 * The user's home directory.
 */
val USER_HOME_DIR = File(System.getProperty("user.home"))


/**
 * The user's desktop directory.
 */
val USER_DESKTOP_DIR = File(System.getProperty("user.home"), "Desktop")


/**
 * The directory where the app stores its user files (fits, settings etc.)
 */
val USER_FILES_DIR = run {
    val appName = "Theorycrafter"
    val appNameLowercase = appName.lowercase(Locale.ROOT)
    File(
        USER_HOME_DIR,
        when (hostOs){
            OS.MacOS -> "Library/Application Support/$appName"
            OS.Windows ->
                if (File(USER_HOME_DIR, "AppData").exists())
                    "AppData\\$appName\\$appName"  // Windows 7 and later
                else
                    "Application Data\\Local Settings\\$appName\\$appName"  // Windows XP
            OS.Linux -> ".local/share/$appNameLowercase"
            else -> ".$appNameLowercase"
        }
    )
}


/**
 * The directory where we write logs.
 */
val LOGS_DIR = File(USER_FILES_DIR, "logs")


/**
 * If the given directory doesn't exist, creates it.
 */
private fun File.createDirIfMissing(){
    if (!isDirectory && !mkdirs())
        throw IOException("Unable to create directory $this")
}


/**
 * Creates the user directories, as needed.
 */
fun createUserDirs(){
    USER_FILES_DIR.createDirIfMissing()
    LOGS_DIR.createDirIfMissing()
}
