package theorycrafter.fitting

import androidx.compose.runtime.Stable
import eve.data.Attributes
import eve.data.SkillType


/**
 * An instance of a skill.
 */
@Stable
class Skill internal constructor(


    /**
     * The context [Attributes].
     */
    attributes: Attributes,


    /**
     * The skill type.
     */
    type: SkillType


) : EveItem<SkillType>(attributes, type) {


    /**
     * The level of the skill.
     */
    val level: AttributeProperty<Int>
        get() = property(attributes.skillLevel)


}