@Suppress("SpellCheckingInspection")
plugins {
    kotlin("jvm") version "2.0.20"
    id("de.undercouch.download") version "4.1.2"  // Download task
    id("org.openapi.generator") version "7.12.0"  // Swagger codegen
}

repositories {
    mavenCentral()
}

dependencies {
    api("com.squareup.okhttp3:okhttp:4.12.0")  // Used by the OpenAPI generated code
    implementation("com.squareup.moshi:moshi-kotlin:1.15.2")  // Used by the OpenAPI generated code
}


// Generate source code classes corresponding to Eve's ESI API via Swagger
// https://github.com/OpenAPITools/openapi-generator/tree/master/modules/openapi-generator-gradle-plugin
val esiSwaggerUrl = project.property("esi.swagger.url") as String
val esiSwaggerFile = "$rootDir/${project.property("esi.swagger.file")}"
val esiSwaggerApiOutputPath: String = openApiGenerate.outputDir.get()  // Use whatever is the default location
val esiSwaggerApiSourcePath = "${esiSwaggerApiOutputPath}/src/main"

// Generate the Kotlin ESI code
val generateEsiApi by tasks.registering(org.openapitools.generator.gradle.plugin.tasks.GenerateTask::class) {
    group = "eve"
    generatorName.set("kotlin")
    inputSpec.set(esiSwaggerFile)
    outputDir.set(esiSwaggerApiOutputPath)
    packageName.set("eve.esi")
    generateApiTests.set(false)
    generateModelTests.set(false)

    mustRunAfter(downloadEsiSwaggerFile)
}

// Download the ESI swagger file
val downloadEsiSwaggerFile = tasks.register<de.undercouch.gradle.tasks.download.Download>("downloadEsiSwaggerFile") {
    src(esiSwaggerUrl)
    dest(esiSwaggerFile)
}

// Re-download the ESI swagger file and re-generate the Kotlin ESI code
tasks.register("updateEsiApi") {
    group = "eve"
    dependsOn(downloadEsiSwaggerFile, generateEsiApi)
}

// Add the generated code to the source sets, so dependent projects get it
sourceSets.main {
    java.srcDirs(esiSwaggerApiSourcePath)
}

kotlin {
    jvmToolchain(17)
}
