/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.tooling;

import androidx.compose.runtime.internal.Utils_desktopKt;
import androidx.compose.runtime.tooling.ComposeToolingApi;
import androidx.compose.runtime.tooling.LocationSourceInformation;
import androidx.compose.runtime.tooling.ParameterSourceInformation;
import androidx.compose.runtime.tooling.ParseException;
import androidx.compose.runtime.tooling.SourceInfoParserState;
import androidx.compose.runtime.tooling.SourceInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u0007H\u0002\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u0007H\u0002\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t*\u00020\u0007H\u0002\u001a\f\u0010\u000e\u001a\u00020\u0003*\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"parseSourceInformation", "Landroidx/compose/runtime/tooling/SourceInformation;", "data", "", "parseSourceInformationInternal", "hasSection", "", "Landroidx/compose/runtime/tooling/SourceInfoParserState;", "parseParameterIndex", "", "Landroidx/compose/runtime/tooling/ParameterSourceInformation;", "parseParameterNames", "parseLocations", "Landroidx/compose/runtime/tooling/LocationSourceInformation;", "replaceComposePrefix", "runtime"})
@SourceDebugExtension(value={"SMAP\nSourceInformation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceInformation.kt\nandroidx/compose/runtime/tooling/SourceInformationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ListUtils.kt\nandroidx/compose/runtime/snapshots/ListUtilsKt\n*L\n1#1,354:1\n1#2:355\n91#3:356\n34#3,5:357\n92#3:362\n91#3:363\n34#3,5:364\n92#3:369\n*S KotlinDebug\n*F\n+ 1 SourceInformation.kt\nandroidx/compose/runtime/tooling/SourceInformationKt\n*L\n239#1:356\n239#1:357,5\n239#1:362\n261#1:363\n261#1:364,5\n261#1:369\n*E\n"})
public final class SourceInformationKt {
    @ComposeToolingApi
    @Nullable
    public static final SourceInformation parseSourceInformation(@NotNull String data) {
        SourceInformation sourceInformation;
        if (((CharSequence)data).length() == 0) {
            return null;
        }
        try {
            sourceInformation = SourceInformationKt.parseSourceInformationInternal(data);
        }
        catch (ParseException e) {
            Utils_desktopKt.logError(e.getMessage(), e);
            sourceInformation = null;
        }
        return sourceInformation;
    }

    @NotNull
    public static final SourceInformation parseSourceInformationInternal(@NotNull String data) {
        String count2;
        boolean isCall = false;
        boolean isInline = false;
        String functionName = null;
        SourceInfoParserState p = new SourceInfoParserState(data);
        if (p.matches('C')) {
            isCall = true;
            SourceInfoParserState.advance$default(p, 0, 1, null);
            if (p.matches('C')) {
                isInline = true;
                SourceInfoParserState.advance$default(p, 0, 1, null);
            }
            if (p.matches('(')) {
                SourceInfoParserState.advance$default(p, 0, 1, null);
                functionName = p.takeUntil(")");
                p.expect(')');
                SourceInfoParserState.advance$default(p, 0, 1, null);
            }
        }
        List<ParameterSourceInformation> parameters = CollectionsKt.emptyList();
        block4: while (SourceInformationKt.hasSection(p)) {
            char sectionType = p.current();
            switch (sectionType) {
                case 'P': {
                    parameters = SourceInformationKt.parseParameterIndex(p);
                    continue block4;
                }
                case 'N': {
                    parameters = SourceInformationKt.parseParameterNames(p);
                    continue block4;
                }
            }
            int count2 = 0;
            p.advance(2);
            while (count2 > 0 || !p.matches(')')) {
                if (p.atEnd()) {
                    p.throwParseError("unexpected end");
                    throw new KotlinNothingValueException();
                }
                if (p.matches('(')) {
                    ++count2;
                } else if (p.matches(')')) {
                    --count2;
                }
                SourceInfoParserState.advance$default(p, 0, 1, null);
            }
            p.expect(')');
            SourceInfoParserState.advance$default(p, 0, 1, null);
        }
        List<LocationSourceInformation> locations = CollectionsKt.emptyList();
        if (!p.matches(':')) {
            locations = SourceInformationKt.parseLocations(p);
        } else {
            SourceInfoParserState.advance$default(p, 0, 1, null);
        }
        String it = count2 = p.takeUntil("#");
        boolean bl = false;
        String fileName = ((CharSequence)it).length() > 0 ? count2 : null;
        String packageHash = null;
        if (p.matches('#')) {
            SourceInfoParserState.advance$default(p, 0, 1, null);
            packageHash = p.takeUntilEnd();
        }
        return new SourceInformation(isCall, isInline, functionName, fileName, parameters, packageHash, locations, data);
    }

    private static final boolean hasSection(SourceInfoParserState $this$hasSection) {
        return $this$hasSection.getI() < $this$hasSection.getData().length() - 1 && Character.isLetter($this$hasSection.getData().charAt($this$hasSection.getI())) && $this$hasSection.getData().charAt($this$hasSection.getI() + 1) == '(';
    }

    private static final List<ParameterSourceInformation> parseParameterIndex(SourceInfoParserState $this$parseParameterIndex) {
        $this$parseParameterIndex.advance(2);
        List parameters = new ArrayList();
        boolean pendingRun = false;
        while (!$this$parseParameterIndex.atEnd() && !$this$parseParameterIndex.matches(')')) {
            int nextIndex;
            if ($this$parseParameterIndex.matches('!')) {
                SourceInfoParserState.advance$default($this$parseParameterIndex, 0, 1, null);
                String countString = $this$parseParameterIndex.takeUntil("!,)");
                if (((CharSequence)countString).length() == 0) {
                    pendingRun = true;
                } else {
                    int count = Integer.parseInt(countString);
                    nextIndex = 0;
                    while (count > 0) {
                        boolean bl;
                        block13: {
                            List $this$fastAny$iv = parameters;
                            boolean $i$f$fastAny = false;
                            List $this$fastForEach$iv$iv = $this$fastAny$iv;
                            boolean $i$f$fastForEach = false;
                            int n = ((Collection)$this$fastForEach$iv$iv).size();
                            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                Object item$iv$iv;
                                Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                                boolean bl2 = false;
                                ParameterSourceInformation it = (ParameterSourceInformation)it$iv;
                                boolean bl3 = false;
                                if (!(it.getSortedIndex() == nextIndex)) continue;
                                bl = true;
                                break block13;
                            }
                            bl = false;
                        }
                        if (bl) {
                            int $this$fastAny$iv = nextIndex;
                            nextIndex = $this$fastAny$iv + 1;
                            continue;
                        }
                        parameters.add(new ParameterSourceInformation(nextIndex, null, null, 6, null));
                        --count;
                    }
                }
            } else {
                int index = $this$parseParameterIndex.takeIntUntil("!:,)");
                String inlineClass = null;
                if ($this$parseParameterIndex.matches(':')) {
                    SourceInfoParserState.advance$default($this$parseParameterIndex, 0, 1, null);
                    inlineClass = SourceInformationKt.replaceComposePrefix($this$parseParameterIndex.takeUntil("!,)"));
                }
                if (pendingRun) {
                    nextIndex = 0;
                    int maxIndex = index;
                    while (nextIndex < maxIndex) {
                        boolean bl;
                        block14: {
                            List $this$fastAny$iv = parameters;
                            boolean $i$f$fastAny = false;
                            List $this$fastForEach$iv$iv = $this$fastAny$iv;
                            boolean $i$f$fastForEach = false;
                            int n = ((Collection)$this$fastForEach$iv$iv).size();
                            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                                Object item$iv$iv;
                                Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                                boolean bl4 = false;
                                ParameterSourceInformation it = (ParameterSourceInformation)it$iv;
                                boolean bl5 = false;
                                if (!(it.getSortedIndex() == nextIndex)) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                        if (bl) {
                            int n = nextIndex;
                            nextIndex = n + 1;
                            continue;
                        }
                        parameters.add(new ParameterSourceInformation(nextIndex, null, null, 6, null));
                    }
                    pendingRun = false;
                }
                parameters.add(new ParameterSourceInformation(index, null, inlineClass, 2, null));
            }
            if (!$this$parseParameterIndex.matches(',')) continue;
            SourceInfoParserState.advance$default($this$parseParameterIndex, 0, 1, null);
        }
        $this$parseParameterIndex.expect(')');
        SourceInfoParserState.advance$default($this$parseParameterIndex, 0, 1, null);
        return parameters;
    }

    private static final List<ParameterSourceInformation> parseParameterNames(SourceInfoParserState $this$parseParameterNames) {
        $this$parseParameterNames.advance(2);
        List parameters = new ArrayList();
        while (!$this$parseParameterNames.atEnd() && !$this$parseParameterNames.matches(')')) {
            String name = $this$parseParameterNames.takeUntil(":,)");
            String inlineClass = null;
            if ($this$parseParameterNames.matches(':')) {
                SourceInfoParserState.advance$default($this$parseParameterNames, 0, 1, null);
                inlineClass = SourceInformationKt.replaceComposePrefix($this$parseParameterNames.takeUntil(",)"));
            }
            int n = parameters.size();
            String string = inlineClass;
            parameters.add(new ParameterSourceInformation(n, name, string));
            if (!$this$parseParameterNames.matches(',')) continue;
            SourceInfoParserState.advance$default($this$parseParameterNames, 0, 1, null);
        }
        $this$parseParameterNames.expect(')');
        SourceInfoParserState.advance$default($this$parseParameterNames, 0, 1, null);
        return parameters;
    }

    private static final List<LocationSourceInformation> parseLocations(SourceInfoParserState $this$parseLocations) {
        List locations = new ArrayList();
        while (!$this$parseLocations.atEnd() && !$this$parseLocations.matches(':')) {
            boolean repeatable = false;
            if ($this$parseLocations.matches('*')) {
                repeatable = true;
                SourceInfoParserState.advance$default($this$parseLocations, 0, 1, null);
            }
            Integer lineNumber = null;
            if (!$this$parseLocations.matches('@')) {
                lineNumber = $this$parseLocations.takeIntUntil("@") + 1;
            }
            SourceInfoParserState.advance$default($this$parseLocations, 0, 1, null);
            int offset = $this$parseLocations.takeIntUntil("L,:");
            Integer length = null;
            if ($this$parseLocations.matches('L')) {
                SourceInfoParserState.advance$default($this$parseLocations, 0, 1, null);
                length = $this$parseLocations.takeIntUntil(",:");
            }
            Integer n = lineNumber;
            Integer n2 = length;
            locations.add(new LocationSourceInformation(n != null ? n : -1, offset, n2 != null ? n2 : -1, repeatable));
            if (!$this$parseLocations.matches(',')) continue;
            SourceInfoParserState.advance$default($this$parseLocations, 0, 1, null);
        }
        SourceInfoParserState.advance$default($this$parseLocations, 0, 1, null);
        return locations;
    }

    private static final String replaceComposePrefix(String $this$replaceComposePrefix) {
        return StringsKt.replaceFirst$default((String)$this$replaceComposePrefix, (String)"c#", (String)"androidx.compose.", (boolean)false, (int)4, null);
    }
}

