/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import theorycrafter.utils.CorruptedStoredCollection;
import theorycrafter.utils.Entry;
import theorycrafter.utils.InputOutput_desktopKt;
import theorycrafter.utils.Metadata;
import theorycrafter.utils.OutputBuffer;
import theorycrafter.utils.PositionDataInputStream;
import theorycrafter.utils.PositionDataOutputStream;
import theorycrafter.utils.PositionInputStream;
import theorycrafter.utils.PositionOutputStream;
import theorycrafter.utils.StoredCollection;

@kotlin.Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a9\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u0002H\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0012*\u00020\nH\u0002\u001a>\u0010\u0016\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b*\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\b0\u00192\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\u000eH\u0002\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000e2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a;\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c*\u00020 2\u0006\u0010!\u001a\u0002H\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000e2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$\u001a\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a8\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u001c0'\"\u0004\b\u0000\u0010\u001c2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u000e2\b\b\u0002\u0010+\u001a\u00020\u0001\u001a\u0016\u0010,\u001a\u00020\u001d*\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0003H\u0002\u001a\u0016\u0010,\u001a\u00020 *\u00020/2\b\b\u0002\u0010.\u001a\u00020\u0003H\u0002\u001a\u0010\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"STORAGE_FORMAT_VERSION", "", "METADATA_POSITION", "", "ENTRY_COUNT_POSITION", "USER_METADATA_POSITION", "initializeFile", "", "M", "file", "Ljava/io/RandomAccessFile;", "itemFormatVersion", "userMetadata", "userMetadataSerializer", "Ltheorycrafter/utils/StoredCollection$Serializer;", "(Ljava/io/RandomAccessFile;ILjava/lang/Object;Ltheorycrafter/utils/StoredCollection$Serializer;)V", "writeMetadata", "metadata", "Ltheorycrafter/utils/Metadata;", "writeEntryCount", "count", "readMetadata", "upgrade", "fromVersion", "initialUserMetadata", "Lkotlin/Function0;", "readEntry", "Ltheorycrafter/utils/Entry;", "T", "Ltheorycrafter/utils/PositionDataInputStream;", "serializer", "writeEntry", "Ltheorycrafter/utils/PositionDataOutputStream;", "item", "buffer", "Ltheorycrafter/utils/OutputBuffer;", "(Ltheorycrafter/utils/PositionDataOutputStream;Ljava/lang/Object;Ltheorycrafter/utils/StoredCollection$Serializer;Ltheorycrafter/utils/OutputBuffer;)Ltheorycrafter/utils/Entry;", "markEntryDeleted", "StoredCollection", "Ltheorycrafter/utils/StoredCollection;", "storageFile", "Ljava/io/File;", "itemSerializer", "typicalMaxItemSizeBytes", "dataWithPosition", "Ljava/io/InputStream;", "initialPosition", "Ljava/io/OutputStream;", "outputBuffer", "initialSize", "SharedApp"})
public final class StoredCollectionKt {
    private static final int STORAGE_FORMAT_VERSION = 2;
    private static final long METADATA_POSITION = 0L;
    private static final long ENTRY_COUNT_POSITION = 8L;
    private static final long USER_METADATA_POSITION = 16L;

    private static final <M> void initializeFile(RandomAccessFile file, int itemFormatVersion, M userMetadata, StoredCollection.Serializer<M> userMetadataSerializer) {
        StoredCollectionKt.writeMetadata(file, new Metadata(2, itemFormatVersion, 0, userMetadataSerializer.getItemFormatVersion()));
        if (!(file.getFilePointer() == 16L)) {
            throw new IllegalStateException("Check failed.");
        }
        userMetadataSerializer.writeItem(file, userMetadata);
    }

    private static final void writeMetadata(RandomAccessFile $this$writeMetadata, Metadata metadata) {
        $this$writeMetadata.seek(0L);
        $this$writeMetadata.writeInt(metadata.getStorageFormatVersion());
        $this$writeMetadata.writeInt(metadata.getItemFormatVersion());
        if (!($this$writeMetadata.getFilePointer() == 8L)) {
            throw new IllegalStateException("Check failed.");
        }
        $this$writeMetadata.writeInt(metadata.getEntryCount());
        $this$writeMetadata.writeInt(metadata.getUserMetadataFormatVersion());
    }

    private static final void writeEntryCount(RandomAccessFile $this$writeEntryCount, int count) {
        $this$writeEntryCount.seek(8L);
        $this$writeEntryCount.writeInt(count);
    }

    private static final Metadata readMetadata(RandomAccessFile $this$readMetadata) {
        $this$readMetadata.seek(0L);
        int storageFormatVersion = $this$readMetadata.readInt();
        int itemFormatVersion = $this$readMetadata.readInt();
        int entryCount = $this$readMetadata.readInt();
        int userMetadataFormatVersion = storageFormatVersion >= 2 ? $this$readMetadata.readInt() : 0;
        return new Metadata(storageFormatVersion, itemFormatVersion, entryCount, userMetadataFormatVersion);
    }

    private static final <M> void upgrade(RandomAccessFile $this$upgrade, int fromVersion, Metadata metadata, Function0<? extends M> initialUserMetadata, StoredCollection.Serializer<M> userMetadataSerializer) {
        if (fromVersion == 1) {
            ByteArrayOutputStream serializedUserMetadata = new ByteArrayOutputStream();
            userMetadataSerializer.writeItem(new DataOutputStream(serializedUserMetadata), initialUserMetadata.invoke());
            int userMetadataSize = serializedUserMetadata.size();
            $this$upgrade.seek(64L);
            InputStream inputStream = Channels.newInputStream($this$upgrade.getChannel());
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            int n = 8192;
            byte[] userData = InputOutput_desktopKt.readToEnd(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            $this$upgrade.seek(16L + (long)userMetadataSize);
            OutputStream outputStream = Channels.newOutputStream($this$upgrade.getChannel());
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            closeable = outputStream;
            n = 8192;
            BufferedOutputStream it22 = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
            boolean bl = false;
            it22.write(userData);
            it22.flush();
            $this$upgrade.setLength($this$upgrade.getFilePointer());
            StoredCollectionKt.writeMetadata($this$upgrade, metadata);
            OutputStream outputStream2 = Channels.newOutputStream($this$upgrade.getChannel());
            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
            closeable = outputStream2;
            int it22 = 8192;
            BufferedOutputStream it = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, it22);
            boolean bl2 = false;
            serializedUserMetadata.writeTo(it);
            it.flush();
        }
    }

    private static final <T> Entry<T> readEntry(PositionDataInputStream $this$readEntry, StoredCollection.Serializer<T> serializer, int itemFormatVersion) {
        Entry<Object> entry;
        long position = $this$readEntry.getPosition();
        boolean isDeleted = $this$readEntry.readBoolean();
        int length = $this$readEntry.readInt();
        if (length < 0) {
            throw new CorruptedStoredCollection("Read negative item length");
        }
        long entryStartPosition = $this$readEntry.getPosition();
        if (isDeleted) {
            InputOutput_desktopKt.skipBytes($this$readEntry, length);
            entry = new Entry<Object>(null, position, length);
        } else {
            T item = serializer.readItem($this$readEntry, itemFormatVersion);
            entry = new Entry<T>(item, position, length);
        }
        Entry<Object> entry2 = entry;
        int readBytes = (int)($this$readEntry.getPosition() - entryStartPosition);
        if (readBytes != length) {
            throw new CorruptedStoredCollection("Entry " + entry2.getItem() + " has length " + length + " but read " + readBytes + " bytes");
        }
        return entry2;
    }

    private static final <T> Entry<T> writeEntry(PositionDataOutputStream $this$writeEntry, T item, StoredCollection.Serializer<T> serializer, OutputBuffer buffer) {
        long position = $this$writeEntry.getPosition();
        buffer.reset();
        serializer.writeItem(buffer, item);
        int length = buffer.size();
        $this$writeEntry.writeBoolean(false);
        $this$writeEntry.writeInt(length);
        buffer.writeTo($this$writeEntry);
        return new Entry<T>(item, position, length);
    }

    private static final void markEntryDeleted(RandomAccessFile file) {
        file.writeBoolean(true);
    }

    @NotNull
    public static final <T> StoredCollection<Unit, T> StoredCollection(@NotNull File storageFile, @NotNull StoredCollection.Serializer<T> itemSerializer, int typicalMaxItemSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter(itemSerializer, (String)"itemSerializer");
        return new StoredCollection<Unit, T>(storageFile, StoredCollection.Companion.getUnitSerializer(), StoredCollectionKt::StoredCollection$lambda$0, StoredCollectionKt::StoredCollection$lambda$1, itemSerializer, typicalMaxItemSizeBytes);
    }

    public static /* synthetic */ StoredCollection StoredCollection$default(File file, StoredCollection.Serializer serializer, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8192;
        }
        return StoredCollectionKt.StoredCollection(file, serializer, n);
    }

    private static final PositionDataInputStream dataWithPosition(InputStream $this$dataWithPosition, long initialPosition) {
        return new PositionDataInputStream(new PositionInputStream($this$dataWithPosition, initialPosition));
    }

    static /* synthetic */ PositionDataInputStream dataWithPosition$default(InputStream inputStream, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        return StoredCollectionKt.dataWithPosition(inputStream, l);
    }

    private static final PositionDataOutputStream dataWithPosition(OutputStream $this$dataWithPosition, long initialPosition) {
        return new PositionDataOutputStream(new PositionOutputStream($this$dataWithPosition, initialPosition));
    }

    static /* synthetic */ PositionDataOutputStream dataWithPosition$default(OutputStream outputStream, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        return StoredCollectionKt.dataWithPosition(outputStream, l);
    }

    private static final OutputBuffer outputBuffer(int initialSize) {
        return new OutputBuffer(new ByteArrayOutputStream(initialSize));
    }

    private static final Unit StoredCollection$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit StoredCollection$lambda$1(Unit unit, int n, Sequence sequence) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ OutputBuffer access$outputBuffer(int initialSize) {
        return StoredCollectionKt.outputBuffer(initialSize);
    }

    public static final /* synthetic */ void access$initializeFile(RandomAccessFile file, int itemFormatVersion, Object userMetadata, StoredCollection.Serializer userMetadataSerializer) {
        StoredCollectionKt.initializeFile(file, itemFormatVersion, userMetadata, userMetadataSerializer);
    }

    public static final /* synthetic */ Metadata access$readMetadata(RandomAccessFile $receiver) {
        return StoredCollectionKt.readMetadata($receiver);
    }

    public static final /* synthetic */ void access$upgrade(RandomAccessFile $receiver, int fromVersion, Metadata metadata, Function0 initialUserMetadata, StoredCollection.Serializer userMetadataSerializer) {
        StoredCollectionKt.upgrade($receiver, fromVersion, metadata, initialUserMetadata, userMetadataSerializer);
    }

    public static final /* synthetic */ Entry access$readEntry(PositionDataInputStream $receiver, StoredCollection.Serializer serializer, int itemFormatVersion) {
        return StoredCollectionKt.readEntry($receiver, serializer, itemFormatVersion);
    }

    public static final /* synthetic */ Entry access$writeEntry(PositionDataOutputStream $receiver, Object item, StoredCollection.Serializer serializer, OutputBuffer buffer) {
        return StoredCollectionKt.writeEntry($receiver, item, serializer, buffer);
    }

    public static final /* synthetic */ void access$writeMetadata(RandomAccessFile $receiver, Metadata metadata) {
        StoredCollectionKt.writeMetadata($receiver, metadata);
    }

    public static final /* synthetic */ void access$writeEntryCount(RandomAccessFile $receiver, int count) {
        StoredCollectionKt.writeEntryCount($receiver, count);
    }

    public static final /* synthetic */ void access$markEntryDeleted(RandomAccessFile file) {
        StoredCollectionKt.markEntryDeleted(file);
    }

    public static final /* synthetic */ PositionDataOutputStream access$dataWithPosition(OutputStream $receiver, long initialPosition) {
        return StoredCollectionKt.dataWithPosition($receiver, initialPosition);
    }

    public static final /* synthetic */ PositionDataInputStream access$dataWithPosition(InputStream $receiver, long initialPosition) {
        return StoredCollectionKt.dataWithPosition($receiver, initialPosition);
    }
}

