/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.fitting;

import androidx.compose.runtime.Stable;
import eve.data.Attribute;
import eve.data.Attributes;
import eve.data.ChargeType;
import eve.data.DamageType;
import eve.data.EveItemType;
import eve.data.SensorType;
import eve.data.utils.ValueByEnum;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.EveItem;
import theorycrafter.fitting.Fit;
import theorycrafter.fitting.FitItem;
import theorycrafter.fitting.MechanicsKt;
import theorycrafter.fitting.MissileRange;
import theorycrafter.fitting.Module;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\r\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R/\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0019\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0019\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0013\u0010#\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0019\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001cR\u0019\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001cR\u0019\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001cR\u0019\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001cR\u0019\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001cR\u0019\u00101\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001cR\u0019\u00103\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001cR\u0019\u00105\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001cR\u0019\u00107\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001cR\u0019\u00109\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001cR/\u0010;\u001a\u0016\u0012\u0004\u0012\u00020<\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b>\u0010\u0019\u001a\u0004\b=\u0010\u0017R\u0019\u0010?\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001cR\u0019\u0010A\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u001cR\u0019\u0010C\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001cR\u0019\u0010E\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001cR\u0019\u0010G\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u001c\u00a8\u0006I"}, d2={"Ltheorycrafter/fitting/Charge;", "Ltheorycrafter/fitting/EveItem;", "Leve/data/ChargeType;", "Ltheorycrafter/fitting/FitItem;", "module", "Ltheorycrafter/fitting/Module;", "attributes", "Leve/data/Attributes;", "type", "<init>", "(Ltheorycrafter/fitting/Module;Leve/data/Attributes;Leve/data/ChargeType;)V", "getModule", "()Ltheorycrafter/fitting/Module;", "fit", "Ltheorycrafter/fitting/Fit;", "getFit", "()Ltheorycrafter/fitting/Fit;", "volleyDamageByType", "Leve/data/utils/ValueByEnum;", "Leve/data/DamageType;", "Ltheorycrafter/fitting/AttributeProperty;", "", "getVolleyDamageByType", "()Leve/data/utils/ValueByEnum;", "volleyDamageByType$delegate", "Lkotlin/Lazy;", "mass", "getMass", "()Ltheorycrafter/fitting/AttributeProperty;", "inertiaModifier", "getInertiaModifier", "missileVelocity", "getMissileVelocity", "missileFlightTime", "getMissileFlightTime", "missileRange", "Ltheorycrafter/fitting/MissileRange;", "getMissileRange", "()Ltheorycrafter/fitting/MissileRange;", "missileExplosionRadius", "getMissileExplosionRadius", "missileExplosionVelocity", "getMissileExplosionVelocity", "missileDamageReductionFactor", "getMissileDamageReductionFactor", "explosionRange", "getExplosionRange", "warpDisruptionRange", "getWarpDisruptionRange", "stasisWebificationRange", "getStasisWebificationRange", "stasisWebificationStrength", "getStasisWebificationStrength", "baseMaxScanDeviation", "getBaseMaxScanDeviation", "baseScanRange", "getBaseScanRange", "baseScanSensorStrength", "getBaseScanSensorStrength", "ecmStrength", "Leve/data/SensorType;", "getEcmStrength", "ecmStrength$delegate", "energyNeutralized", "getEnergyNeutralized", "dotMaxDamagePerTick", "getDotMaxDamagePerTick", "dotMaxHpPctDamagePerTick", "getDotMaxHpPctDamagePerTick", "dotDuration", "getDotDuration", "aoeRange", "getAoeRange", "FittingEngine"})
@Stable
@SourceDebugExtension(value={"SMAP\nCharge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Charge.kt\ntheorycrafter/fitting/Charge\n+ 2 ValueByEnum.kt\neve/data/utils/ValueByEnumKt\n*L\n1#1,221:1\n40#2,3:222\n40#2,3:225\n*S KotlinDebug\n*F\n+ 1 Charge.kt\ntheorycrafter/fitting/Charge\n*L\n51#1:222,3\n180#1:225,3\n*E\n"})
public final class Charge
extends EveItem<ChargeType>
implements FitItem {
    @NotNull
    private final Module module;
    @NotNull
    private final Lazy volleyDamageByType$delegate;
    @NotNull
    private final Lazy ecmStrength$delegate;
    public static final int $stable;

    public Charge(@NotNull Module module, @NotNull Attributes attributes, @NotNull ChargeType type) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super(attributes, (EveItemType)type, null);
        this.module = module;
        this.volleyDamageByType$delegate = LazyKt.lazy(() -> Charge.volleyDamageByType_delegate$lambda$1(this, attributes));
        this.ecmStrength$delegate = LazyKt.lazy(() -> Charge.ecmStrength_delegate$lambda$3(this, attributes));
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @Override
    @NotNull
    public Fit getFit() {
        return this.module.getFit();
    }

    @NotNull
    public final ValueByEnum<DamageType, AttributeProperty<Double>> getVolleyDamageByType() {
        Lazy lazy = this.volleyDamageByType$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @Nullable
    public final AttributeProperty<Double> getMass() {
        return this.propertyOrNull(this.getAttributes().getMass());
    }

    @Nullable
    public final AttributeProperty<Double> getInertiaModifier() {
        return this.propertyOrNull(this.getAttributes().getInertiaModifier());
    }

    @Nullable
    public final AttributeProperty<Double> getMissileVelocity() {
        return this.propertyOrNull(this.getAttributes().getMaxVelocity());
    }

    @Nullable
    public final AttributeProperty<Double> getMissileFlightTime() {
        return this.propertyOrNull(this.getAttributes().getMissileFlightTime());
    }

    @Nullable
    public final MissileRange getMissileRange() {
        AttributeProperty<Double> attributeProperty = this.getMissileVelocity();
        if (attributeProperty == null) {
            return null;
        }
        double velocity = attributeProperty.getDoubleValue();
        AttributeProperty<Double> attributeProperty2 = this.getMissileFlightTime();
        if (attributeProperty2 == null) {
            return null;
        }
        double flightTime = attributeProperty2.getDoubleValue();
        AttributeProperty<Double> attributeProperty3 = this.getMass();
        if (attributeProperty3 == null) {
            return null;
        }
        double mass = attributeProperty3.getDoubleValue();
        AttributeProperty<Double> attributeProperty4 = this.getInertiaModifier();
        if (attributeProperty4 == null) {
            return null;
        }
        double inertiaModifier = attributeProperty4.getDoubleValue();
        double shipRadius = this.module.getFit().getShip().getRadius().getDoubleValue();
        return MechanicsKt.missileRange(velocity, flightTime, mass, inertiaModifier, shipRadius);
    }

    @Nullable
    public final AttributeProperty<Double> getMissileExplosionRadius() {
        return this.propertyOrNull(this.getAttributes().getAoeCloudSize());
    }

    @Nullable
    public final AttributeProperty<Double> getMissileExplosionVelocity() {
        return this.propertyOrNull(this.getAttributes().getAoeVelocity());
    }

    @Nullable
    public final AttributeProperty<Double> getMissileDamageReductionFactor() {
        return this.propertyOrNull(this.getAttributes().getAoeDamageReductionFactor());
    }

    @Nullable
    public final AttributeProperty<Double> getExplosionRange() {
        return this.propertyOrNull(this.getAttributes().getExplosionRange());
    }

    @Nullable
    public final AttributeProperty<Double> getWarpDisruptionRange() {
        return this.propertyOrNull(this.getAttributes().getWarpScrambleRange());
    }

    @Nullable
    public final AttributeProperty<Double> getStasisWebificationRange() {
        return this.getAoeRange();
    }

    @Nullable
    public final AttributeProperty<Double> getStasisWebificationStrength() {
        return this.propertyOrNull(this.getAttributes().getSpeedFactor());
    }

    @Nullable
    public final AttributeProperty<Double> getBaseMaxScanDeviation() {
        return this.propertyOrNull(this.getAttributes().getBaseMaxScanDeviation());
    }

    @Nullable
    public final AttributeProperty<Double> getBaseScanRange() {
        return this.propertyOrNull(this.getAttributes().getBaseScanRange());
    }

    @Nullable
    public final AttributeProperty<Double> getBaseScanSensorStrength() {
        return this.propertyOrNull(this.getAttributes().getBaseScanSensorStrength());
    }

    @NotNull
    public final ValueByEnum<SensorType, AttributeProperty<Double>> getEcmStrength() {
        Lazy lazy = this.ecmStrength$delegate;
        return (ValueByEnum)lazy.getValue();
    }

    @Nullable
    public final AttributeProperty<Double> getEnergyNeutralized() {
        return this.propertyOrNull(this.getAttributes().getEnergyNeutralizerAmount());
    }

    @Nullable
    public final AttributeProperty<Double> getDotMaxDamagePerTick() {
        return this.propertyOrNull(this.getAttributes().getDotMaxDamagePerTick());
    }

    @Nullable
    public final AttributeProperty<Double> getDotMaxHpPctDamagePerTick() {
        return this.propertyOrNull(this.getAttributes().getDotMaxHpPctDamagePerTick());
    }

    @Nullable
    public final AttributeProperty<Double> getDotDuration() {
        return this.propertyOrNull(this.getAttributes().getDotDuration());
    }

    @Nullable
    public final AttributeProperty<Double> getAoeRange() {
        return this.propertyOrNull(this.getAttributes().getAoeRange());
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum volleyDamageByType_delegate$lambda$1(Charge this$0, Attributes $attributes) {
        boolean $i$f$valueByEnum = false;
        DamageType[] enumValues$iv = DamageType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void damageType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            DamageType damageType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)$attributes.getDamage().get((Enum)damageType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final ValueByEnum ecmStrength_delegate$lambda$3(Charge this$0, Attributes $attributes) {
        boolean $i$f$valueByEnum = false;
        SensorType[] enumValues$iv = SensorType.values();
        int n = 0;
        int n2 = enumValues$iv.length;
        Object[] objectArray = new AttributeProperty[n2];
        while (n < n2) {
            void sensorType;
            AttributeProperty attributeProperty;
            int n3 = n++;
            SensorType sensorType2 = enumValues$iv[n3];
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            objectArray2[n4] = attributeProperty = this$0.propertyOrNull((Attribute)$attributes.getEcmStrength().get((Enum)sensorType));
        }
        Object[] valueByOrdinal$iv = objectArray;
        return new ValueByEnum(valueByOrdinal$iv);
    }
}

