/*
 * Decompiled with CFR 0.152.
 */
package eve.esi.infrastructure;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import eve.esi.infrastructure.ApiAbstractionsKt;
import eve.esi.infrastructure.ApiClientKt;
import eve.esi.infrastructure.ApiResponse;
import eve.esi.infrastructure.ClientError;
import eve.esi.infrastructure.Informational;
import eve.esi.infrastructure.PartConfig;
import eve.esi.infrastructure.Redirection;
import eve.esi.infrastructure.RequestConfig;
import eve.esi.infrastructure.RequestMethod;
import eve.esi.infrastructure.ResponseExtensionsKt;
import eve.esi.infrastructure.Serializer;
import eve.esi.infrastructure.ServerError;
import eve.esi.infrastructure.Success;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 .2\u00020\u0001:\u0001.B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J0\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J=\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u0018*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00172\b\u0010\u0019\u001a\u0004\u0018\u0001H\u0018H\u0004\u00a2\u0006\u0002\u0010\u001aJ(\u0010\u001b\u001a\u00020\u001c\"\u0006\b\u0000\u0010\u0018\u0018\u00012\u0006\u0010\u001d\u001a\u0002H\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u001fJ2\u0010 \u001a\u0004\u0018\u0001H\u0018\"\f\b\u0000\u0010\u0018\u0018\u0001*\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00182\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00180&H\u0004J5\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00180(\"\u0006\b\u0000\u0010)\u0018\u0001\"\f\b\u0001\u0010\u0018\u0018\u0001*\u0004\u0018\u00010\u00012\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H)0&H\u0084\bJ\u0012\u0010*\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010,\u001a\u00020\u0003\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u00012\u0006\u0010+\u001a\u0002H\u0018H\u0084\b\u00a2\u0006\u0002\u0010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Leve/esi/infrastructure/ApiClient;", "", "baseUrl", "", "client", "Lokhttp3/Call$Factory;", "<init>", "(Ljava/lang/String;Lokhttp3/Call$Factory;)V", "getBaseUrl", "()Ljava/lang/String;", "getClient", "()Lokhttp3/Call$Factory;", "guessContentTypeFromByteArray", "byteArray", "", "guessContentTypeFromFile", "file", "Ljava/io/File;", "addPartToMultiPart", "", "Lokhttp3/MultipartBody$Builder;", "name", "headers", "", "T", "obj", "(Lokhttp3/MultipartBody$Builder;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Object;)V", "requestBody", "Lokhttp3/RequestBody;", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;Ljava/lang/String;)Ljava/lang/Object;", "updateAuthParams", "requestConfig", "Leve/esi/infrastructure/RequestConfig;", "request", "Leve/esi/infrastructure/ApiResponse;", "I", "parameterToString", "value", "parseDateToQueryString", "(Ljava/lang/Object;)Ljava/lang/String;", "Companion", "Esi"})
@SourceDebugExtension(value={"SMAP\nApiClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiClient.kt\neve/esi/infrastructure/ApiClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n*L\n1#1,369:1\n131#1,10:381\n141#1,4:392\n145#1,6:397\n152#1,3:404\n155#1,6:408\n161#1,2:415\n163#1,15:418\n131#1,10:433\n141#1,4:444\n145#1,6:449\n152#1,3:456\n155#1,6:460\n161#1,2:467\n163#1,15:470\n131#1,10:485\n141#1,4:496\n145#1,6:501\n152#1,3:508\n155#1,6:512\n161#1,2:519\n163#1,15:522\n131#1,10:537\n141#1,4:548\n145#1,6:553\n152#1,3:560\n155#1,6:564\n161#1,2:571\n163#1,15:574\n181#1,64:591\n246#1,3:656\n366#1:659\n216#2:370\n217#2:373\n216#2,2:374\n216#2:377\n217#2:380\n216#2:391\n217#2:407\n216#2:414\n217#2:417\n216#2:443\n217#2:459\n216#2:466\n217#2:469\n216#2:495\n217#2:511\n216#2:518\n217#2:521\n216#2:547\n217#2:563\n216#2:570\n217#2:573\n216#2,2:589\n1863#3,2:371\n1863#3,2:378\n1863#3:396\n1864#3:403\n1863#3:448\n1864#3:455\n1863#3:500\n1864#3:507\n1863#3:552\n1864#3:559\n29#4:376\n29#4:655\n*S KotlinDebug\n*F\n+ 1 ApiClient.kt\neve/esi/infrastructure/ApiClient\n*L\n297#1:381,10\n297#1:392,4\n297#1:397,6\n297#1:404,3\n297#1:408,6\n297#1:415,2\n297#1:418,15\n300#1:433,10\n300#1:444,4\n300#1:449,6\n300#1:456,3\n300#1:460,6\n300#1:467,2\n300#1:470,15\n301#1:485,10\n301#1:496,4\n301#1:501,6\n301#1:508,3\n301#1:512,6\n301#1:519,2\n301#1:522,15\n302#1:537,10\n302#1:548,4\n302#1:553,6\n302#1:560,3\n302#1:564,6\n302#1:571,2\n302#1:574,15\n330#1:591,64\n330#1:656,3\n355#1:659\n140#1:370\n140#1:373\n160#1:374,2\n269#1:377\n269#1:380\n297#1:391\n297#1:407\n297#1:414\n297#1:417\n300#1:443\n300#1:459\n300#1:466\n300#1:469\n301#1:495\n301#1:511\n301#1:518\n301#1:521\n302#1:547\n302#1:563\n302#1:570\n302#1:573\n306#1:589,2\n144#1:371,2\n270#1:378,2\n297#1:396\n297#1:403\n300#1:448\n300#1:455\n301#1:500\n301#1:507\n302#1:552\n302#1:559\n244#1:376\n330#1:655\n*E\n"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    private final Call.Factory client;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    protected static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    protected static final String OctetMediaType = "application/octet-stream";
    @NotNull
    protected static final String TextMediaType = "text/plain";
    @NotNull
    private static final Map<String, String> apiKey = new LinkedHashMap();
    @NotNull
    private static final Map<String, String> apiKeyPrefix = new LinkedHashMap();
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    public static final String baseUrlKey = "eve.esi.baseUrl";
    @NotNull
    private static final Lazy<OkHttpClient> defaultClient$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;

    public ApiClient(@NotNull String baseUrl, @NotNull Call.Factory client) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public /* synthetic */ ApiClient(String string, Call.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            factory = (Call.Factory)Companion.getDefaultClient();
        }
        this(string, factory);
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    public final Call.Factory getClient() {
        return this.client;
    }

    @NotNull
    protected final String guessContentTypeFromByteArray(@NotNull byte[] byteArray) {
        String string;
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        try {
            string = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(byteArray));
        }
        catch (IOException io) {
            string = OctetMediaType;
        }
        String contentType = string;
        Intrinsics.checkNotNull((Object)contentType);
        return contentType;
    }

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String contentType = URLConnection.guessContentTypeFromName(file.getName());
        String string = contentType;
        if (string == null) {
            string = OctetMediaType;
        }
        return string;
    }

    protected final void addPartToMultiPart(@NotNull MultipartBody.Builder $this$addPartToMultiPart, @NotNull String name, @NotNull Map<String, String> headers, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$addPartToMultiPart, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(headers), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"")));
        MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile(file));
        $this$addPartToMultiPart.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create(file, fileMediaType));
    }

    protected final <T> void addPartToMultiPart(@NotNull MultipartBody.Builder $this$addPartToMultiPart, @NotNull String name, @NotNull Map<String, String> headers, @Nullable T obj) {
        Intrinsics.checkNotNullParameter((Object)$this$addPartToMultiPart, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Map partHeaders = MapsKt.plus((Map)MapsKt.toMutableMap(headers), (Pair)TuplesKt.to((Object)"Content-Disposition", (Object)("form-data; name=\"" + name + "\"")));
        $this$addPartToMultiPart.addPart(Headers.Companion.of(partHeaders), RequestBody.Companion.create(this.parameterToString(obj), null));
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        boolean $i$f$requestBody = false;
        if (content instanceof byte[]) {
            byte[] byArray = (byte[])content;
            String string = mediaType;
            if (string == null) {
                string = this.guessContentTypeFromByteArray((byte[])content);
            }
            requestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])byArray, (MediaType)MediaType.Companion.parse(string), (int)0, (int)0, (int)6, null);
        } else if (content instanceof File) {
            File file = (File)content;
            String string = mediaType;
            if (string == null) {
                string = this.guessContentTypeFromFile((File)content);
            }
            requestBody = RequestBody.Companion.create(file, MediaType.Companion.parse(string));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder;
            MultipartBody.Builder $this$requestBody_u24lambda_u242 = builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                Object t = part.getBody();
                if (t instanceof File) {
                    this.addPartToMultiPart($this$requestBody_u24lambda_u242, name, (Map<String, String>)part.getHeaders(), (Object)((File)part.getBody()));
                    continue;
                }
                if (t instanceof List) {
                    Iterable $this$forEach$iv2 = (Iterable)part.getBody();
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv2.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv2;
                        Object it = element$iv2 = iterator2.next();
                        boolean bl3 = false;
                        if (it instanceof File) {
                            this.addPartToMultiPart($this$requestBody_u24lambda_u242, name, (Map<String, String>)part.getHeaders(), (Object)((File)it));
                            continue;
                        }
                        this.addPartToMultiPart($this$requestBody_u24lambda_u242, name, (Map<String, String>)part.getHeaders(), it);
                    }
                    continue;
                }
                this.addPartToMultiPart($this$requestBody_u24lambda_u242, name, (Map<String, String>)part.getHeaders(), part.getBody());
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder;
            FormBody.Builder $this$requestBody_u24lambda_u244 = builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            Intrinsics.checkNotNull(content, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl4 = false;
                String name = (String)entry.getKey();
                PartConfig part = (PartConfig)entry.getValue();
                $this$requestBody_u24lambda_u244.add(name, this.parameterToString(part.getBody()));
            }
            requestBody = (RequestBody)builder.build();
        } else if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            if (content == null) {
                requestBody = ApiClientKt.getEMPTY_REQUEST();
            } else {
                Moshi moshi = Serializer.getMoshi();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                String string = moshi.adapter(Object.class).toJson(content);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                String string2 = mediaType;
                if (string2 == null) {
                    string2 = JsonMediaType;
                }
                requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(string2));
            }
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            if (Intrinsics.areEqual((Object)mediaType, (Object)TextMediaType) && content instanceof String) {
                requestBody = RequestBody.Companion.create((String)content, MediaType.Companion.parse(TextMediaType));
            } else {
                throw new UnsupportedOperationException("requestBody currently only supports JSON body, text body, byte body and File body.");
            }
        }
        return requestBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <T> T responseBody(Response response, String mediaType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        boolean $i$f$responseBody = false;
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, Unit.class)) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            Object object2;
            String string;
            Pattern pattern;
            Matcher matcher;
            String contentDisposition = Response.header$default((Response)response, (String)"Content-Disposition", null, (int)2, null);
            String string2 = contentDisposition != null ? ((matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find() ? ((string = matcher.group(1)) != null && (object2 = StringsKt.replace$default((String)string, (String)".*[/\\\\]", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default((String)object2, (String)";", (String)"", (boolean)false, (int)4, null) : null) : (String)null) : (String)null;
            String fileName = string2;
            String prefix = null;
            String suffix = null;
            if (fileName == null) {
                prefix = "download";
                suffix = "";
            } else {
                int pos = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null);
                if (pos == -1) {
                    prefix = fileName;
                    suffix = null;
                } else {
                    String string3 = fileName.substring(0, pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    prefix = string3;
                    String string4 = fileName.substring(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    suffix = string4;
                }
                if (prefix.length() < 3) {
                    prefix = "download";
                }
            }
            File tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            object2 = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)object2;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)tempFile;
        }
        if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            String bodyContent = body.string();
            if (((CharSequence)bodyContent).length() == 0) {
                return null;
            }
            Moshi $this$adapter$iv = Serializer.getMoshi();
            boolean $i$f$adapter = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            object = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType)) {
            byte[] byArray = body.bytes();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object = byArray;
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)TextMediaType)) {
            String string = body.string();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object = string;
        } else {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body, text body and byte body.");
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object responseBody$default(ApiClient $this, Response response, String mediaType, int n, Object object) {
        Object object2;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        boolean $i$f$responseBody = false;
        ResponseBody body = response.body();
        if (body == null) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, Unit.class)) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            Object object3;
            String string;
            Pattern pattern;
            Matcher matcher;
            String contentDisposition = Response.header$default((Response)response, (String)"Content-Disposition", null, (int)2, null);
            String string2 = contentDisposition != null ? ((matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition)).find() ? ((string = matcher.group(1)) != null && (object3 = StringsKt.replace$default((String)string, (String)".*[/\\\\]", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default((String)object3, (String)";", (String)"", (boolean)false, (int)4, null) : null) : (String)null) : (String)null;
            String fileName = string2;
            String prefix = null;
            String suffix = null;
            if (fileName == null) {
                prefix = "download";
                suffix = "";
            } else {
                int pos = StringsKt.lastIndexOf$default((CharSequence)fileName, (String)".", (int)0, (boolean)false, (int)6, null);
                if (pos == -1) {
                    prefix = fileName;
                    suffix = null;
                } else {
                    String string3 = fileName.substring(0, pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    prefix = string3;
                    String string4 = fileName.substring(pos);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    suffix = string4;
                }
                if (prefix.length() < 3) {
                    prefix = "download";
                }
            }
            File tempFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
            tempFile.deleteOnExit();
            object3 = body.byteStream();
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream = (InputStream)object3;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)tempFile);
                Closeable closeable = new FileOutputStream(tempFile);
                Throwable throwable2 = null;
                try {
                    FileOutputStream tempFileOutputStream = (FileOutputStream)closeable;
                    boolean bl2 = false;
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)tempFileOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return tempFile;
        }
        if (mediaType == null || StringsKt.startsWith$default((String)mediaType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)mediaType, (String)"json", (boolean)false, (int)2, null)) {
            String bodyContent = body.string();
            if (((CharSequence)bodyContent).length() == 0) {
                return null;
            }
            Moshi $this$adapter$iv = Serializer.getMoshi();
            boolean $i$f$adapter = false;
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            object2 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)OctetMediaType)) {
            byte[] byArray = body.bytes();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object2 = byArray;
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)TextMediaType)) {
            String string = body.string();
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            object2 = string;
        } else {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body, text body and byte body.");
        }
        return object2;
    }

    protected final <T> void updateAuthParams(@NotNull RequestConfig<T> requestConfig) {
        block1: {
            Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
            CharSequence charSequence = requestConfig.getHeaders().get(Authorization);
            if (!(charSequence == null || charSequence.length() == 0)) break block1;
            String string = accessToken;
            if (string != null) {
                String accessToken = string;
                boolean bl = false;
                requestConfig.getHeaders().put(Authorization, "Bearer " + accessToken + " ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final /* synthetic */ <I, T> ApiResponse<T> request(RequestConfig<I> requestConfig) {
        ApiResponse apiResponse;
        String string;
        FormBody.Builder $this$requestBody_u24lambda_u244$iv;
        String name$iv;
        String string2;
        Map<String, String> headers;
        Iterator queryValue;
        Map.Entry<String, List<String>> element$iv;
        Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        this.updateAuthParams(requestConfig);
        Object object = new char[]{'/'};
        object = httpUrl2.newBuilder().addEncodedPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])object));
        Object $this$request_u24lambda_u2410 = (HttpUrl.Builder)object;
        boolean bl4 = false;
        Request.Builder $this$forEach$iv = requestConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry<String, List<String>> query = element$iv = object2.next();
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = query.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                queryValue = (String)element$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u2410.addQueryParameter(query.getKey(), (String)((Object)queryValue));
            }
        }
        HttpUrl url = ((HttpUrl.Builder)object).build();
        if (requestConfig.getBody() != null && ((object = (Object)requestConfig.getHeaders().get(ContentType)) == null || object.length() == 0)) {
            requestConfig.getHeaders().put(ContentType, JsonMediaType);
        }
        if ((object = (Object)requestConfig.getHeaders().get(Accept)) == null || object.length() == 0) {
            requestConfig.getHeaders().put(Accept, JsonMediaType);
        }
        if (($this$request_u24lambda_u2410 = (CharSequence)(headers = requestConfig.getHeaders()).get(Accept)) == null || $this$request_u24lambda_u2410.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        if (headers.get(ContentType) != null) {
            String string3 = headers.get(ContentType);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type kotlin.String");
            String bl4 = StringsKt.substringBefore$default((String)string3, (String)";", null, (int)2, null);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string4 = bl4.toLowerCase(locale);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        String contentType = string2;
        Request.Builder $this$request_u24lambda_u2412 = $this$forEach$iv = (switch (WhenMappings.$EnumSwitchMapping$0[requestConfig.getMethod().ordinal()]) {
            case 1 -> {
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$1$iv;
                Object it$iv;
                Object element$iv$iv;
                Iterator var28_79;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv$iv;
                Object var24_72;
                PartConfig part$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var20_63;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u242$iv;
                RequestBody v7;
                ApiClient this_$iv;
                I content$iv;
                object2 = this;
                element$iv = requestConfig.getBody();
                Request.Builder var34_62 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof byte[]) {
                    byte[] v5 = (byte[])content$iv;
                    String v6 = contentType;
                    if (v6 == null) {
                        v6 = this_$iv.guessContentTypeFromByteArray((byte[])content$iv);
                    }
                    v7 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])v5, (MediaType)MediaType.Companion.parse(v6), (int)0, (int)0, (int)6, null);
                } else if (content$iv instanceof File) {
                    File v8 = (File)content$iv;
                    String v9 = contentType;
                    if (v9 == null) {
                        v9 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v7 = RequestBody.Companion.create(v8, MediaType.Companion.parse(v9));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    $this$requestBody_u24lambda_u242$iv = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    queryValue = $this$forEach$iv$iv.entrySet().iterator();
                    while (queryValue.hasNext()) {
                        Map.Entry element$iv$iv;
                        var20_63 = element$iv$iv = queryValue.next();
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        var24_72 = part$iv.getBody();
                        if (var24_72 instanceof File) {
                            this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)part$iv.getBody()));
                            continue;
                        }
                        if (var24_72 instanceof List) {
                            $this$forEach$iv$iv = (Iterable)part$iv.getBody();
                            $i$f$forEach = false;
                            var28_79 = $this$forEach$iv$iv.iterator();
                            while (var28_79.hasNext()) {
                                it$iv = element$iv$iv = var28_79.next();
                                $i$a$-forEach-ApiClient$requestBody$1$1$1$iv = false;
                                if (it$iv instanceof File) {
                                    this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)it$iv));
                                    continue;
                                }
                                this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), it$iv);
                            }
                            continue;
                        }
                        this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), part$iv.getBody());
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u244$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        $this$requestBody_u24lambda_u244$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v7 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v7 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v10 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v11 = v10.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"toJson(...)");
                        String v12 = contentType;
                        if (v12 == null) {
                            v12 = JsonMediaType;
                        }
                        v7 = RequestBody.Companion.create(v11, MediaType.Companion.parse(v12));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)TextMediaType) && content$iv instanceof String) {
                        v7 = RequestBody.Companion.create((String)content$iv, MediaType.Companion.parse(TextMediaType));
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, text body, byte body and File body.");
                    }
                }
                yield var34_62.delete(v7);
            }
            case 2 -> new Request.Builder().url(url);
            case 3 -> new Request.Builder().url(url).head();
            case 4 -> {
                RequestBody v16;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$1$iv;
                Object it$iv;
                Object element$iv$iv;
                Iterator var28_79;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv$iv;
                Object var24_72;
                PartConfig part$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var20_63;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u242$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var34_62 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof byte[]) {
                    byte[] v14 = (byte[])content$iv;
                    String v15 = contentType;
                    if (v15 == null) {
                        v15 = this_$iv.guessContentTypeFromByteArray((byte[])content$iv);
                    }
                    v16 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])v14, (MediaType)MediaType.Companion.parse(v15), (int)0, (int)0, (int)6, null);
                } else if (content$iv instanceof File) {
                    File v17 = (File)content$iv;
                    String v18 = contentType;
                    if (v18 == null) {
                        v18 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v16 = RequestBody.Companion.create(v17, MediaType.Companion.parse(v18));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    $this$requestBody_u24lambda_u242$iv = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        var24_72 = part$iv.getBody();
                        if (var24_72 instanceof File) {
                            this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)part$iv.getBody()));
                            continue;
                        }
                        if (var24_72 instanceof List) {
                            $this$forEach$iv$iv = (Iterable)part$iv.getBody();
                            $i$f$forEach = false;
                            var28_79 = $this$forEach$iv$iv.iterator();
                            while (var28_79.hasNext()) {
                                it$iv = element$iv$iv = var28_79.next();
                                $i$a$-forEach-ApiClient$requestBody$1$1$1$iv = false;
                                if (it$iv instanceof File) {
                                    this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)it$iv));
                                    continue;
                                }
                                this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), it$iv);
                            }
                            continue;
                        }
                        this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), part$iv.getBody());
                    }
                    v16 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u244$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        $this$requestBody_u24lambda_u244$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v16 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v16 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v19 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v20 = v19.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"toJson(...)");
                        String v21 = contentType;
                        if (v21 == null) {
                            v21 = JsonMediaType;
                        }
                        v16 = RequestBody.Companion.create(v20, MediaType.Companion.parse(v21));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)TextMediaType) && content$iv instanceof String) {
                        v16 = RequestBody.Companion.create((String)content$iv, MediaType.Companion.parse(TextMediaType));
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, text body, byte body and File body.");
                    }
                }
                yield var34_62.patch(v16);
            }
            case 5 -> {
                RequestBody v24;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$1$iv;
                Object it$iv;
                Object element$iv$iv;
                Iterator var28_79;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv$iv;
                Object var24_72;
                PartConfig part$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var20_63;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u242$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var34_62 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof byte[]) {
                    byte[] v22 = (byte[])content$iv;
                    String v23 = contentType;
                    if (v23 == null) {
                        v23 = this_$iv.guessContentTypeFromByteArray((byte[])content$iv);
                    }
                    v24 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])v22, (MediaType)MediaType.Companion.parse(v23), (int)0, (int)0, (int)6, null);
                } else if (content$iv instanceof File) {
                    File v25 = (File)content$iv;
                    String v26 = contentType;
                    if (v26 == null) {
                        v26 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v24 = RequestBody.Companion.create(v25, MediaType.Companion.parse(v26));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    $this$requestBody_u24lambda_u242$iv = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        var24_72 = part$iv.getBody();
                        if (var24_72 instanceof File) {
                            this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)part$iv.getBody()));
                            continue;
                        }
                        if (var24_72 instanceof List) {
                            $this$forEach$iv$iv = (Iterable)part$iv.getBody();
                            $i$f$forEach = false;
                            var28_79 = $this$forEach$iv$iv.iterator();
                            while (var28_79.hasNext()) {
                                it$iv = element$iv$iv = var28_79.next();
                                $i$a$-forEach-ApiClient$requestBody$1$1$1$iv = false;
                                if (it$iv instanceof File) {
                                    this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)it$iv));
                                    continue;
                                }
                                this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), it$iv);
                            }
                            continue;
                        }
                        this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), part$iv.getBody());
                    }
                    v24 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u244$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        $this$requestBody_u24lambda_u244$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v24 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v24 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v27 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v28 = v27.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"toJson(...)");
                        String v29 = contentType;
                        if (v29 == null) {
                            v29 = JsonMediaType;
                        }
                        v24 = RequestBody.Companion.create(v28, MediaType.Companion.parse(v29));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)TextMediaType) && content$iv instanceof String) {
                        v24 = RequestBody.Companion.create((String)content$iv, MediaType.Companion.parse(TextMediaType));
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, text body, byte body and File body.");
                    }
                }
                yield var34_62.put(v24);
            }
            case 6 -> {
                RequestBody v32;
                boolean $i$a$-forEach-ApiClient$requestBody$2$1$iv;
                boolean $i$a$-apply-ApiClient$requestBody$2$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$1$iv;
                Object it$iv;
                Object element$iv$iv;
                Iterator var28_79;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv$iv;
                Object var24_72;
                PartConfig part$iv;
                boolean $i$a$-forEach-ApiClient$requestBody$1$1$iv;
                Map.Entry var20_63;
                Map $this$forEach$iv$iv;
                boolean $i$a$-apply-ApiClient$requestBody$1$iv;
                MultipartBody.Builder $this$requestBody_u24lambda_u242$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder var34_62 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof byte[]) {
                    byte[] v30 = (byte[])content$iv;
                    String v31 = contentType;
                    if (v31 == null) {
                        v31 = this_$iv.guessContentTypeFromByteArray((byte[])content$iv);
                    }
                    v32 = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])v30, (MediaType)MediaType.Companion.parse(v31), (int)0, (int)0, (int)6, null);
                } else if (content$iv instanceof File) {
                    File v33 = (File)content$iv;
                    String v34 = contentType;
                    if (v34 == null) {
                        v34 = this_$iv.guessContentTypeFromFile((File)content$iv);
                    }
                    v32 = RequestBody.Companion.create(v33, MediaType.Companion.parse(v34));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder bl2;
                    $this$requestBody_u24lambda_u242$iv = bl2 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    $i$a$-apply-ApiClient$requestBody$1$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$1$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        var24_72 = part$iv.getBody();
                        if (var24_72 instanceof File) {
                            this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)part$iv.getBody()));
                            continue;
                        }
                        if (var24_72 instanceof List) {
                            $this$forEach$iv$iv = (Iterable)part$iv.getBody();
                            $i$f$forEach = false;
                            var28_79 = $this$forEach$iv$iv.iterator();
                            while (var28_79.hasNext()) {
                                it$iv = element$iv$iv = var28_79.next();
                                $i$a$-forEach-ApiClient$requestBody$1$1$1$iv = false;
                                if (it$iv instanceof File) {
                                    this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), (Object)((File)it$iv));
                                    continue;
                                }
                                this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), it$iv);
                            }
                            continue;
                        }
                        this_$iv.addPartToMultiPart($this$requestBody_u24lambda_u242$iv, name$iv, (Map<String, String>)part$iv.getHeaders(), part$iv.getBody());
                    }
                    v32 = (RequestBody)bl2.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder bl2;
                    $this$requestBody_u24lambda_u244$iv = bl2 = new FormBody.Builder(null, 1, null);
                    $i$a$-apply-ApiClient$requestBody$2$iv = false;
                    Intrinsics.checkNotNull(content$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, eve.esi.infrastructure.PartConfig<*>>");
                    $this$forEach$iv$iv = (Map)content$iv;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv : $this$forEach$iv$iv.entrySet()) {
                        var20_63 = element$iv$iv;
                        $i$a$-forEach-ApiClient$requestBody$2$1$iv = false;
                        name$iv = (String)var20_63.getKey();
                        part$iv = (PartConfig)var20_63.getValue();
                        $this$requestBody_u24lambda_u244$iv.add(name$iv, this_$iv.parameterToString(part$iv.getBody()));
                    }
                    v32 = (RequestBody)bl2.build();
                } else if (contentType == null || StringsKt.startsWith$default((String)contentType, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv == null) {
                        v32 = ApiClientKt.getEMPTY_REQUEST();
                    } else {
                        Moshi v35 = Serializer.getMoshi();
                        Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                        String v36 = v35.adapter(Object.class).toJson(content$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v36, (String)"toJson(...)");
                        String v37 = contentType;
                        if (v37 == null) {
                            v37 = JsonMediaType;
                        }
                        v32 = RequestBody.Companion.create(v36, MediaType.Companion.parse(v37));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    if (Intrinsics.areEqual((Object)contentType, (Object)TextMediaType) && content$iv instanceof String) {
                        v32 = RequestBody.Companion.create((String)content$iv, MediaType.Companion.parse(TextMediaType));
                    } else {
                        throw new UnsupportedOperationException("requestBody currently only supports JSON body, text body, byte body and File body.");
                    }
                }
                yield var34_62.post(v32);
            }
            case 7 -> new Request.Builder().url(url).method("OPTIONS", null);
            default -> throw new NoWhenBranchMatchedException();
        });
        boolean bl5 = false;
        Headers.Builder headersBuilder = new Headers.Builder();
        Object $this$forEach$iv3 = headers;
        boolean $i$f$forEach3 = false;
        $this$requestBody_u24lambda_u244$iv = $this$forEach$iv3.entrySet().iterator();
        while ($this$requestBody_u24lambda_u244$iv.hasNext()) {
            Map.Entry<String, String> element$iv3;
            Map.Entry<String, String> header = element$iv3 = $this$requestBody_u24lambda_u244$iv.next();
            boolean bl6 = false;
            headersBuilder.add(header.getKey(), header.getValue());
        }
        $this$request_u24lambda_u2412.headers(headersBuilder.build());
        Request request = $this$forEach$iv.build();
        Response response = this.getClient().newCall(request).execute();
        String string5 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (string5 != null && (string5 = StringsKt.substringBefore$default((String)string5, (String)";", null, (int)2, null)) != null) {
            $this$forEach$iv3 = string5;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string6 = ((String)$this$forEach$iv3).toLowerCase(locale);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String accept = string;
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            ApiResponse apiResponse2;
            Response it = (Response)closeable;
            boolean bl7 = false;
            if (it.isRedirect()) {
                apiResponse2 = new Redirection(it.code(), it.headers().toMultimap());
            } else if (ResponseExtensionsKt.isInformational(it)) {
                apiResponse2 = new Informational(it.message(), it.code(), it.headers().toMultimap());
            } else if (it.isSuccessful()) {
                Object object3;
                ApiClient this_$iv = this;
                boolean $i$f$responseBody = false;
                ResponseBody body$iv = it.body();
                if (body$iv == null) {
                    object3 = null;
                } else {
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                    if (Intrinsics.areEqual(Object.class, Unit.class)) {
                        object3 = null;
                    } else {
                        Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                        if (Intrinsics.areEqual(Object.class, File.class)) {
                            Object object4;
                            Pattern pattern$iv;
                            Matcher matcher$iv;
                            String contentDisposition$iv = Response.header$default((Response)it, (String)"Content-Disposition", null, (int)2, null);
                            String string7 = contentDisposition$iv != null ? ((matcher$iv = (pattern$iv = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition$iv)).find() ? ((name$iv = matcher$iv.group(1)) != null && (object4 = StringsKt.replace$default((String)name$iv, (String)".*[/\\\\]", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.replace$default((String)object4, (String)";", (String)"", (boolean)false, (int)4, null) : null) : (String)null) : (String)null;
                            String fileName$iv = string7;
                            String prefix$iv = null;
                            String suffix$iv = null;
                            if (fileName$iv == null) {
                                prefix$iv = "download";
                                suffix$iv = "";
                            } else {
                                int pos$iv = StringsKt.lastIndexOf$default((CharSequence)fileName$iv, (String)".", (int)0, (boolean)false, (int)6, null);
                                if (pos$iv == -1) {
                                    prefix$iv = fileName$iv;
                                    suffix$iv = null;
                                } else {
                                    String string8 = fileName$iv.substring(0, pos$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                                    prefix$iv = string8;
                                    String string9 = fileName$iv.substring(pos$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"substring(...)");
                                    suffix$iv = string9;
                                }
                                if (prefix$iv.length() < 3) {
                                    prefix$iv = "download";
                                }
                            }
                            File tempFile$iv = Files.createTempFile(prefix$iv, suffix$iv, new FileAttribute[0]).toFile();
                            tempFile$iv.deleteOnExit();
                            object4 = body$iv.byteStream();
                            Throwable throwable2 = null;
                            try {
                                long l;
                                InputStream inputStream$iv = (InputStream)object4;
                                boolean bl8 = false;
                                Intrinsics.checkNotNull((Object)tempFile$iv);
                                Closeable closeable2 = new FileOutputStream(tempFile$iv);
                                Throwable throwable3 = null;
                                try {
                                    FileOutputStream tempFileOutputStream$iv = (FileOutputStream)closeable2;
                                    boolean bl9 = false;
                                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream$iv, (OutputStream)tempFileOutputStream$iv, (int)0, (int)2, null);
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    InlineMarker.finallyStart((int)1);
                                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                                    InlineMarker.finallyEnd((int)1);
                                }
                                long l2 = l;
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                InlineMarker.finallyStart((int)1);
                                CloseableKt.closeFinally((Closeable)object4, (Throwable)throwable2);
                                InlineMarker.finallyEnd((int)1);
                            }
                            Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                            object3 = tempFile$iv;
                        } else if (accept == null || StringsKt.startsWith$default((String)accept, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept, (String)"json", (boolean)false, (int)2, null)) {
                            String bodyContent$iv = body$iv.string();
                            if (((CharSequence)bodyContent$iv).length() == 0) {
                                object3 = null;
                            } else {
                                Moshi $this$adapter$iv$iv = Serializer.getMoshi();
                                boolean $i$f$adapter = false;
                                Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
                                object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv, null).fromJson(bodyContent$iv);
                            }
                        } else if (Intrinsics.areEqual((Object)accept, (Object)OctetMediaType)) {
                            byte[] byArray = body$iv.bytes();
                            Intrinsics.reifiedOperationMarker((int)2, (String)"T?");
                            object3 = byArray;
                        } else if (Intrinsics.areEqual((Object)accept, (Object)TextMediaType)) {
                            String string10 = body$iv.string();
                            Intrinsics.reifiedOperationMarker((int)2, (String)"T?");
                            object3 = string10;
                        } else {
                            throw new UnsupportedOperationException("responseBody currently only supports JSON body, text body and byte body.");
                        }
                    }
                }
                Map map = it.headers().toMultimap();
                int n = it.code();
                Object object5 = object3;
                apiResponse2 = new Success<Object>(object5, n, (Map<String, List<String>>)((Map<String, ? extends List<String>>)map));
            } else if (ResponseExtensionsKt.isClientError(it)) {
                ResponseBody responseBody = it.body();
                apiResponse2 = new ClientError(it.message(), responseBody != null ? responseBody.string() : null, it.code(), it.headers().toMultimap());
            } else {
                ResponseBody responseBody = it.body();
                apiResponse2 = new ServerError(it.message(), responseBody != null ? responseBody.string() : null, it.code(), it.headers().toMultimap());
            }
            apiResponse = apiResponse2;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return apiResponse;
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "";
        } else if (object instanceof Object[]) {
            string = ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        } else if (object instanceof Iterable) {
            string = ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        } else if (object instanceof OffsetDateTime || object instanceof OffsetTime || object instanceof LocalDateTime || object instanceof LocalDate || object instanceof LocalTime) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string2 = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
            string = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
        } else {
            string = value.toString();
        }
        return string;
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$parseDateToQueryString = false;
        Moshi moshi = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi.adapter(Object.class).toJson(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    private static final OkHttpClient defaultClient_delegate$lambda$14() {
        return builder.build();
    }

    @NotNull
    public static final OkHttpClient getDefaultClient() {
        return Companion.getDefaultClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        return Companion.getBuilder();
    }

    static {
        defaultClient$delegate = LazyKt.lazy(ApiClient::defaultClient_delegate$lambda$14);
        builder = new OkHttpClient.Builder();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010 \u001a\u00020!8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010&\u0012\u0004\b\"\u0010\u0003\u001a\u0004\b#\u0010$R\u001c\u0010'\u001a\u00020(8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\u0003\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Leve/esi/infrastructure/ApiClient$Companion;", "", "<init>", "()V", "ContentType", "", "Accept", "Authorization", "JsonMediaType", "FormDataMediaType", "FormUrlEncMediaType", "XmlMediaType", "OctetMediaType", "TextMediaType", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "username", "getUsername", "()Ljava/lang/String;", "setUsername", "(Ljava/lang/String;)V", "password", "getPassword", "setPassword", "accessToken", "getAccessToken", "setAccessToken", "baseUrlKey", "defaultClient", "Lokhttp3/OkHttpClient;", "getDefaultClient$annotations", "getDefaultClient", "()Lokhttp3/OkHttpClient;", "defaultClient$delegate", "Lkotlin/Lazy;", "builder", "Lokhttp3/OkHttpClient$Builder;", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "Esi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        @NotNull
        public final OkHttpClient getDefaultClient() {
            Lazy lazy = defaultClient$delegate;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultClient$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=176)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            try {
                nArray[RequestMethod.DELETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.GET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.HEAD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.PUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.POST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

