/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.tournaments;

import eve.data.EveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import theorycrafter.CompositionExportTemplatesSettings;
import theorycrafter.FitHandle;
import theorycrafter.TheorycrafterContext;
import theorycrafter.formats.EftExportOptions;
import theorycrafter.formats.EftKt;
import theorycrafter.storage.StoredFit;
import theorycrafter.tournaments.Composition;
import theorycrafter.ui.ShortNamesKt;
import theorycrafter.ui.tournaments.CompositionImportExportKt;
import theorycrafter.ui.tournaments.UtilitySummaryLine;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ltheorycrafter/ui/tournaments/CompositionTemplateReplacements;", "", "composition", "Ltheorycrafter/tournaments/Composition;", "templateSettings", "Ltheorycrafter/CompositionExportTemplatesSettings;", "<init>", "(Ltheorycrafter/tournaments/Composition;Ltheorycrafter/CompositionExportTemplatesSettings;)V", "getComposition", "()Ltheorycrafter/tournaments/Composition;", "getTemplateSettings", "()Ltheorycrafter/CompositionExportTemplatesSettings;", "title", "", "ship", "Ltheorycrafter/tournaments/Composition$Ship;", "count", "", "utilityLine", "line", "Ltheorycrafter/ui/tournaments/UtilitySummaryLine;", "note", "Theorycrafter"})
@SourceDebugExtension(value={"SMAP\nCompositionImportExport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositionImportExport.kt\ntheorycrafter/ui/tournaments/CompositionTemplateReplacements\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,947:1\n1#2:948\n1557#3:949\n1628#3,3:950\n*S KotlinDebug\n*F\n+ 1 CompositionImportExport.kt\ntheorycrafter/ui/tournaments/CompositionTemplateReplacements\n*L\n586#1:949\n586#1:950,3\n*E\n"})
final class CompositionTemplateReplacements {
    @NotNull
    private final Composition composition;
    @NotNull
    private final CompositionExportTemplatesSettings templateSettings;

    public CompositionTemplateReplacements(@NotNull Composition composition, @NotNull CompositionExportTemplatesSettings templateSettings) {
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Intrinsics.checkNotNullParameter((Object)templateSettings, (String)"templateSettings");
        this.composition = composition;
        this.templateSettings = templateSettings;
    }

    @NotNull
    public final Composition getComposition() {
        return this.composition;
    }

    @NotNull
    public final CompositionExportTemplatesSettings getTemplateSettings() {
        return this.templateSettings;
    }

    @NotNull
    public final String title() {
        String result2 = this.templateSettings.getTitleTemplate();
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "compName", this.composition.getName());
        return result2;
    }

    @NotNull
    public final String ship(@NotNull Composition.Ship ship, int count) {
        StoredFit storedFit;
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Integer n = ship.getFitId();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            FitHandle fitHandle = TheorycrafterContext.INSTANCE.getFits().handleById(it);
            storedFit = fitHandle != null ? fitHandle.getStoredFit() : null;
        } else {
            storedFit = null;
        }
        StoredFit storedFit2 = storedFit;
        String result2 = this.templateSettings.getShipTemplate();
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "shipCount", String.valueOf(count));
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "shipName", ship.getShipType().getName());
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "shipShortName", ShortNamesKt.shortName(ship.getShipType()));
        Object object = storedFit2;
        if (object == null || (object = ((StoredFit)object).getName()) == null) {
            object = "Unspecified";
        }
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "fitName", (String)object);
        EveData eveData = TheorycrafterContext.INSTANCE.getEveData();
        CharSequence charSequence = result2;
        Regex regex = CompositionImportExportKt.access$getEftFitTokenRegex$p();
        Function1 function1 = arg_0 -> CompositionTemplateReplacements.ship$lambda$3(storedFit2, eveData, arg_0);
        result2 = regex.replace(charSequence, function1);
        return result2;
    }

    @NotNull
    public final String utilityLine(@NotNull UtilitySummaryLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String result2 = this.templateSettings.getUtilityTemplate();
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "utilityCount", String.valueOf(line.getCount()));
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "utilityName", line.getName());
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "utilitySummary", line.getPlainTextSummary());
        return result2;
    }

    @NotNull
    public final String note() {
        String result2 = this.templateSettings.getNoteTemplate();
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "note", this.composition.getNote());
        result2 = CompositionImportExportKt.access$replaceTemplateToken(result2, "plainShipList", CollectionsKt.joinToString$default((Iterable)CollectionsKt.filterNotNull((Iterable)this.composition.getShips()), (CharSequence)"\n", null, null, (int)0, null, CompositionTemplateReplacements::note$lambda$4, (int)30, null));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final CharSequence ship$lambda$3(StoredFit $storedFit, EveData $eveData, MatchResult matchResult) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        if ($storedFit != null) {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)((CharSequence)matchResult.getGroupValues().get(1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            Set options = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            EveData $this$ship_u24lambda_u243_u24lambda_u242 = $eveData;
            boolean bl = false;
            string2 = EftKt.toEft($this$ship_u24lambda_u243_u24lambda_u242, $storedFit, new EftExportOptions(options.contains("charges"), options.contains("implants"), options.contains("boosters"), options.contains("cargo"), options.contains("mutations")));
        } else {
            string2 = "Unspecified fit\n";
        }
        return string2;
    }

    private static final CharSequence note$lambda$4(Composition.Ship it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getShipType().getName();
    }
}

