/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.settings;

import compose.widgets.SingleItemSelectionModel;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.SkillSetHandle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ<\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0004R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR0\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Ltheorycrafter/ui/settings/SkillSetSelectionModel;", "Lcompose/widgets/SingleItemSelectionModel;", "builtInSkillSets", "", "Ltheorycrafter/SkillSetHandle;", "characterSkillSets", "customSkillSets", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "value", "getCharacterSkillSets", "()Ljava/util/List;", "setCharacterSkillSets", "(Ljava/util/List;)V", "getCustomSkillSets", "setCustomSkillSets", "updateSection", "", "current", "updated", "selected", "setField", "Lkotlin/Function0;", "maxSelectableIndex", "", "getMaxSelectableIndex", "()I", "isSelectable", "", "index", "getSelected", "()Ltheorycrafter/SkillSetHandle;", "select", "skillSet", "Theorycrafter"})
final class SkillSetSelectionModel
extends SingleItemSelectionModel {
    @NotNull
    private final List<SkillSetHandle> builtInSkillSets;
    @NotNull
    private List<? extends SkillSetHandle> characterSkillSets;
    @NotNull
    private List<? extends SkillSetHandle> customSkillSets;

    public SkillSetSelectionModel(@NotNull List<? extends SkillSetHandle> builtInSkillSets, @NotNull List<? extends SkillSetHandle> characterSkillSets, @NotNull List<? extends SkillSetHandle> customSkillSets) {
        Intrinsics.checkNotNullParameter(builtInSkillSets, (String)"builtInSkillSets");
        Intrinsics.checkNotNullParameter(characterSkillSets, (String)"characterSkillSets");
        Intrinsics.checkNotNullParameter(customSkillSets, (String)"customSkillSets");
        super(null);
        this.builtInSkillSets = builtInSkillSets;
        this.characterSkillSets = characterSkillSets;
        this.customSkillSets = customSkillSets;
    }

    @NotNull
    public final List<SkillSetHandle> getCharacterSkillSets() {
        return this.characterSkillSets;
    }

    public final void setCharacterSkillSets(@NotNull List<? extends SkillSetHandle> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.updateSection(this.characterSkillSets, value, this.getSelected(), (Function0<Unit>)((Function0)() -> SkillSetSelectionModel._set_characterSkillSets_$lambda$0(this, value)));
    }

    @NotNull
    public final List<SkillSetHandle> getCustomSkillSets() {
        return this.customSkillSets;
    }

    public final void setCustomSkillSets(@NotNull List<? extends SkillSetHandle> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.updateSection(this.customSkillSets, value, this.getSelected(), (Function0<Unit>)((Function0)() -> SkillSetSelectionModel._set_customSkillSets_$lambda$1(this, value)));
    }

    private final void updateSection(List<? extends SkillSetHandle> current, List<? extends SkillSetHandle> updated, SkillSetHandle selected2, Function0<Unit> setField) {
        SkillSetHandle skillSetHandle;
        if (updated.size() > current.size()) {
            skillSetHandle = (SkillSetHandle)CollectionsKt.last(updated);
        } else if (updated.size() < current.size() && Intrinsics.areEqual((Object)selected2, (Object)CollectionsKt.last(current))) {
            if (!((Collection)updated).isEmpty()) {
                skillSetHandle = (SkillSetHandle)CollectionsKt.lastOrNull(updated);
            } else if (Intrinsics.areEqual(current, this.customSkillSets)) {
                skillSetHandle = (SkillSetHandle)CollectionsKt.lastOrNull(this.characterSkillSets);
                if (skillSetHandle == null) {
                    skillSetHandle = (SkillSetHandle)CollectionsKt.last(this.builtInSkillSets);
                }
            } else {
                skillSetHandle = (SkillSetHandle)CollectionsKt.firstOrNull(this.customSkillSets);
                if (skillSetHandle == null) {
                    skillSetHandle = (SkillSetHandle)CollectionsKt.last(this.builtInSkillSets);
                }
            }
        } else {
            skillSetHandle = null;
        }
        SkillSetHandle updateToSkillSet = skillSetHandle;
        setField.invoke();
        if (updateToSkillSet != null) {
            this.select(updateToSkillSet);
        }
    }

    public int getMaxSelectableIndex() {
        return this.builtInSkillSets.size() + this.characterSkillSets.size() + this.customSkillSets.size() + 2;
    }

    public boolean isSelectable(int index) {
        return index != 0 && index != this.builtInSkillSets.size() + 1 && index != this.builtInSkillSets.size() + 1 + this.characterSkillSets.size() + 1;
    }

    @Nullable
    public final SkillSetHandle getSelected() {
        SkillSetHandle skillSetHandle;
        SkillSetSelectionModel $this$_get_selected__u24lambda_u242 = this;
        boolean bl = false;
        Integer index = $this$_get_selected__u24lambda_u242.getSelectedIndex();
        if (index == null) {
            skillSetHandle = null;
        } else {
            index = index - 1;
            if (new IntRange(0, CollectionsKt.getLastIndex($this$_get_selected__u24lambda_u242.builtInSkillSets)).contains(index.intValue())) {
                skillSetHandle = $this$_get_selected__u24lambda_u242.builtInSkillSets.get(index);
            } else {
                index = index - (1 + $this$_get_selected__u24lambda_u242.builtInSkillSets.size());
                if (new IntRange(0, CollectionsKt.getLastIndex($this$_get_selected__u24lambda_u242.characterSkillSets)).contains(index.intValue())) {
                    skillSetHandle = $this$_get_selected__u24lambda_u242.characterSkillSets.get(index);
                } else {
                    index = index - (1 + $this$_get_selected__u24lambda_u242.characterSkillSets.size());
                    skillSetHandle = new IntRange(0, CollectionsKt.getLastIndex($this$_get_selected__u24lambda_u242.customSkillSets)).contains(index.intValue()) ? $this$_get_selected__u24lambda_u242.customSkillSets.get(index) : null;
                }
            }
        }
        return skillSetHandle;
    }

    public final void select(@NotNull SkillSetHandle skillSet2) {
        Intrinsics.checkNotNullParameter((Object)skillSet2, (String)"skillSet");
        int indexInBuiltIn = this.builtInSkillSets.indexOf(skillSet2);
        if (indexInBuiltIn != -1) {
            this.selectIndex(indexInBuiltIn + 1);
            return;
        }
        int indexInCharacter = this.characterSkillSets.indexOf(skillSet2);
        if (indexInCharacter != -1) {
            this.selectIndex(indexInCharacter + this.builtInSkillSets.size() + 2);
            return;
        }
        int indexInCustom = this.customSkillSets.indexOf(skillSet2);
        if (indexInCustom != -1) {
            this.selectIndex(indexInCustom + this.builtInSkillSets.size() + this.characterSkillSets.size() + 3);
            return;
        }
        throw new IllegalArgumentException("Unknown skill set handle: " + skillSet2);
    }

    private static final Unit _set_characterSkillSets_$lambda$0(SkillSetSelectionModel this$0, List $value) {
        this$0.characterSkillSets = $value;
        return Unit.INSTANCE;
    }

    private static final Unit _set_customSkillSets_$lambda$1(SkillSetSelectionModel this$0, List $value) {
        this$0.customSkillSets = $value;
        return Unit.INSTANCE;
    }
}

