/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui.fiteditor;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.internal.ComposableLambdaKt;
import eve.data.ValueFormatsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import theorycrafter.fitting.AttributeProperty;
import theorycrafter.fitting.Charge;
import theorycrafter.fitting.DroneGroup;
import theorycrafter.fitting.MissileRange;
import theorycrafter.fitting.Module;
import theorycrafter.fitting.ModuleOrDrone;
import theorycrafter.ui.fiteditor.ValueWithDescription;
import theorycrafter.ui.fiteditor.ValueWithDescriptionTableKt;
import theorycrafter.ui.widgets.TextAndTooltip;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\u0004\u001a\u0015\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\b\u001a\u0010\u0010\t\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\nH\u0002\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u0006\u0012\u0002\b\u00030\nH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0001*\u00020\u001aH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u0010H\u0002\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0010H\u0002\u001a\f\u0010\u001f\u001a\u00020\u001e*\u00020\u0010H\u0002\u001a\f\u0010 \u001a\u00020\u001e*\u00020!H\u0002\u00a8\u0006\""}, d2={"displayedModuleRange", "Ltheorycrafter/ui/widgets/TextAndTooltip;", "module", "Ltheorycrafter/fitting/Module;", "(Ltheorycrafter/fitting/Module;Landroidx/compose/runtime/Composer;I)Ltheorycrafter/ui/widgets/TextAndTooltip;", "displayedDroneRange", "droneGroup", "Ltheorycrafter/fitting/DroneGroup;", "(Ltheorycrafter/fitting/DroneGroup;Landroidx/compose/runtime/Composer;I)Ltheorycrafter/ui/widgets/TextAndTooltip;", "standardDisplayedRange", "Ltheorycrafter/fitting/ModuleOrDrone;", "standardTooltipItems", "", "Ltheorycrafter/ui/fiteditor/ValueWithDescription;", "optimalTooltipItem", "optimal", "", "falloffTooltipItem", "falloff", "trackingSpeedTooltipItem", "trackingSpeed", "signatureRadiusTooltipItem", "signatureRadius", "aoeRangeTooltipItem", "aoeRadius", "missileDisplayedRange", "Ltheorycrafter/fitting/Charge;", "displayedRange", "range", "asTooltipDistance", "", "asTooltipChance", "asString", "Ltheorycrafter/fitting/MissileRange;", "Theorycrafter"})
public final class RangeColumnKt {
    @Composable
    @Nullable
    public static final TextAndTooltip displayedModuleRange(@NotNull Module module, @Nullable Composer $composer, int $changed) {
        Double stasisWebificationRange;
        Double warpDisruptionRange;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        $composer.startReplaceGroup(-881439244);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-881439244, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedModuleRange (RangeColumn.kt:17)");
        }
        if (module.getOptimalRange() != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.standardDisplayedRange((ModuleOrDrone)module);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return textAndTooltip;
        }
        Charge charge = module.getLoadedCharge();
        if (charge != null && charge.getMissileRange() != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.missileDisplayedRange(charge);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return textAndTooltip;
        }
        Charge charge2 = charge;
        Double d = charge2 != null && (charge2 = charge2.getWarpDisruptionRange()) != null ? Double.valueOf(charge2.getDoubleValue()) : (warpDisruptionRange = null);
        if (warpDisruptionRange != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.displayedRange(warpDisruptionRange);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return textAndTooltip;
        }
        Charge charge3 = charge;
        Double d2 = charge3 != null && (charge3 = charge3.getStasisWebificationRange()) != null ? Double.valueOf(charge3.getDoubleValue()) : (stasisWebificationRange = null);
        if (stasisWebificationRange != null) {
            TextAndTooltip textAndTooltip = RangeColumnKt.displayedRange(stasisWebificationRange);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return textAndTooltip;
        }
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return null;
    }

    @Composable
    @NotNull
    public static final TextAndTooltip displayedDroneRange(@NotNull DroneGroup droneGroup, @Nullable Composer $composer, int $changed) {
        Intrinsics.checkNotNullParameter((Object)droneGroup, (String)"droneGroup");
        $composer.startReplaceGroup(-394596619);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-394596619, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedDroneRange (RangeColumn.kt:41)");
        }
        TextAndTooltip textAndTooltip = RangeColumnKt.standardDisplayedRange((ModuleOrDrone)droneGroup);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return textAndTooltip;
    }

    private static final TextAndTooltip standardDisplayedRange(ModuleOrDrone<?> $this$standardDisplayedRange) {
        if ($this$standardDisplayedRange instanceof DroneGroup && ((DroneGroup)$this$standardDisplayedRange).getMwdSpeed() != null) {
            AttributeProperty attributeProperty = ((DroneGroup)$this$standardDisplayedRange).getMwdSpeed();
            Intrinsics.checkNotNull((Object)attributeProperty);
            double speed = attributeProperty.getDoubleValue();
            String speedText = ValueFormatsKt.asSpeed$default((double)speed, (boolean)false, (boolean)false, (int)0, (int)7, null);
            return new TextAndTooltip(speedText, 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)99424180, (boolean)true, (Object)new Function2<Composer, Integer, Unit>($this$standardDisplayedRange){
                final /* synthetic */ ModuleOrDrone<?> $this_standardDisplayedRange;
                {
                    this.$this_standardDisplayedRange = $receiver;
                }

                @Composable
                @ComposableTarget(applier="androidx.compose.ui.UiComposable")
                public final void invoke(Composer $composer, int $changed) {
                    if (($changed & 3) != 2 || !$composer.getSkipping()) {
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventStart((int)99424180, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.standardDisplayedRange.<anonymous> (RangeColumn.kt:54)");
                        }
                        ValueWithDescriptionTableKt.ValueWithDescriptionTable(RangeColumnKt.access$standardTooltipItems(this.$this_standardDisplayedRange), null, null, $composer, 0, 6);
                        if (ComposerKt.isTraceInProgress()) {
                            ComposerKt.traceEventEnd();
                        }
                    } else {
                        $composer.skipToGroupEnd();
                    }
                }
            }), 2, null);
        }
        AttributeProperty attributeProperty = $this$standardDisplayedRange.getOptimalRange();
        Intrinsics.checkNotNull((Object)attributeProperty);
        double optimal = attributeProperty.getDoubleValue();
        AttributeProperty attributeProperty2 = $this$standardDisplayedRange.getFalloffRange();
        Double falloff = attributeProperty2 != null ? Double.valueOf(attributeProperty2.getDoubleValue()) : null;
        return new TextAndTooltip(ValueFormatsKt.asRange$default((double)optimal, (Double)falloff, (boolean)false, (int)4, null), 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)1887206489, (boolean)true, (Object)new Function2<Composer, Integer, Unit>($this$standardDisplayedRange){
            final /* synthetic */ ModuleOrDrone<?> $this_standardDisplayedRange;
            {
                this.$this_standardDisplayedRange = $receiver;
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)1887206489, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.standardDisplayedRange.<anonymous> (RangeColumn.kt:62)");
                    }
                    ValueWithDescriptionTableKt.ValueWithDescriptionTable(RangeColumnKt.access$standardTooltipItems(this.$this_standardDisplayedRange), null, null, $composer, 0, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }), 2, null);
    }

    private static final List<ValueWithDescription> standardTooltipItems(ModuleOrDrone<?> $this$standardTooltipItems) {
        List list;
        AttributeProperty attributeProperty = $this$standardTooltipItems.getOptimalRange();
        Intrinsics.checkNotNull((Object)attributeProperty);
        double optimal = attributeProperty.getDoubleValue();
        AttributeProperty attributeProperty2 = $this$standardTooltipItems.getFalloffRange();
        Double falloff = attributeProperty2 != null ? Double.valueOf(attributeProperty2.getDoubleValue()) : null;
        AttributeProperty attributeProperty3 = $this$standardTooltipItems.getTrackingSpeed();
        Double trackingSpeed = attributeProperty3 != null ? Double.valueOf(attributeProperty3.getDoubleValue()) : null;
        Module module = $this$standardTooltipItems instanceof Module ? (Module)$this$standardTooltipItems : null;
        Double signatureRadius = module != null && (module = module.getSignatureRadius()) != null ? Double.valueOf(module.getDoubleValue()) : null;
        Module module2 = $this$standardTooltipItems instanceof Module ? (Module)$this$standardTooltipItems : null;
        Double aoeRange = module2 != null && (module2 = module2.getAoeRange()) != null ? Double.valueOf(module2.getDoubleValue()) : null;
        List $this$standardTooltipItems_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)2);
        boolean bl = false;
        $this$standardTooltipItems_u24lambda_u240.add(RangeColumnKt.optimalTooltipItem(optimal));
        if (falloff != null && !Intrinsics.areEqual((Double)falloff, (double)0.0)) {
            $this$standardTooltipItems_u24lambda_u240.add(RangeColumnKt.falloffTooltipItem(falloff));
        }
        if (trackingSpeed != null) {
            $this$standardTooltipItems_u24lambda_u240.add(RangeColumnKt.trackingSpeedTooltipItem(trackingSpeed));
        }
        if (signatureRadius != null) {
            $this$standardTooltipItems_u24lambda_u240.add(RangeColumnKt.signatureRadiusTooltipItem(signatureRadius));
        }
        if (aoeRange != null) {
            $this$standardTooltipItems_u24lambda_u240.add(RangeColumnKt.aoeRangeTooltipItem(aoeRange));
        }
        return CollectionsKt.build((List)list);
    }

    private static final ValueWithDescription optimalTooltipItem(double optimal) {
        return new ValueWithDescription(RangeColumnKt.asTooltipDistance(optimal), "optimal range");
    }

    private static final ValueWithDescription falloffTooltipItem(double falloff) {
        return new ValueWithDescription(RangeColumnKt.asTooltipDistance(falloff), "falloff range");
    }

    private static final ValueWithDescription trackingSpeedTooltipItem(double trackingSpeed) {
        return new ValueWithDescription(ValueFormatsKt.asTrackingSpeed$default((double)trackingSpeed, (boolean)false, (int)1, null), "tracking speed");
    }

    private static final ValueWithDescription signatureRadiusTooltipItem(double signatureRadius) {
        return new ValueWithDescription(ValueFormatsKt.asDistance$default((double)signatureRadius, (boolean)false, (boolean)false, (int)0, (int)7, null), "signature radius");
    }

    private static final ValueWithDescription aoeRangeTooltipItem(double aoeRadius) {
        return new ValueWithDescription(ValueFormatsKt.asDistance$default((double)aoeRadius, (boolean)false, (boolean)false, (int)0, (int)7, null), "effect radius");
    }

    private static final TextAndTooltip missileDisplayedRange(Charge $this$missileDisplayedRange) {
        List list;
        MissileRange missileRange = $this$missileDisplayedRange.getMissileRange();
        Intrinsics.checkNotNull((Object)missileRange);
        MissileRange range = missileRange;
        AttributeProperty attributeProperty = $this$missileDisplayedRange.getMissileVelocity();
        Double velocity = attributeProperty != null ? Double.valueOf(attributeProperty.getDoubleValue()) : null;
        AttributeProperty attributeProperty2 = $this$missileDisplayedRange.getMissileFlightTime();
        Double flightTime = attributeProperty2 != null ? Double.valueOf(attributeProperty2.getDoubleValue()) : null;
        AttributeProperty attributeProperty3 = $this$missileDisplayedRange.getMissileExplosionRadius();
        Double explosionRadius = attributeProperty3 != null ? Double.valueOf(attributeProperty3.getDoubleValue()) : null;
        AttributeProperty attributeProperty4 = $this$missileDisplayedRange.getMissileExplosionVelocity();
        Double explosionVelocity = attributeProperty4 != null ? Double.valueOf(attributeProperty4.getDoubleValue()) : null;
        List $this$missileDisplayedRange_u24lambda_u241 = list = CollectionsKt.createListBuilder((int)5);
        boolean bl = false;
        $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(RangeColumnKt.asTooltipDistance(range.getShortRange()), "with " + RangeColumnKt.asTooltipChance(range.getShortProbability()) + " chance"));
        $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(RangeColumnKt.asTooltipDistance(range.getLongRange()), "with " + RangeColumnKt.asTooltipChance(range.getLongProbability()) + " chance"));
        double averageRange = range.getAverageRange();
        $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(RangeColumnKt.asTooltipDistance(averageRange), "avg. flight distance"));
        if (velocity != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.asSpeed$default((double)velocity, (boolean)false, (boolean)false, (int)0, (int)7, null), "flight velocity"));
        }
        if (flightTime != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.millisAsTimeSec$default((double)flightTime, (boolean)false, (boolean)false, null, (int)7, null), "flight time"));
        }
        if (explosionRadius != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.asDistance$default((double)explosionRadius, (boolean)false, (boolean)false, (int)0, (int)7, null), "explosion radius"));
        }
        if (explosionVelocity != null) {
            $this$missileDisplayedRange_u24lambda_u241.add(new ValueWithDescription(ValueFormatsKt.asSpeed$default((double)explosionVelocity, (boolean)false, (boolean)false, (int)0, (int)7, null), "explosion velocity"));
        }
        List tooltipItems = CollectionsKt.build((List)list);
        return new TextAndTooltip(RangeColumnKt.asString(range), 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)1269603023, (boolean)true, (Object)new Function2<Composer, Integer, Unit>((List<ValueWithDescription>)tooltipItems){
            final /* synthetic */ List<ValueWithDescription> $tooltipItems;
            {
                this.$tooltipItems = $tooltipItems;
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)1269603023, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.missileDisplayedRange.<anonymous> (RangeColumn.kt:214)");
                    }
                    ValueWithDescriptionTableKt.ValueWithDescriptionTable(this.$tooltipItems, null, null, $composer, 0, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }), 2, null);
    }

    private static final TextAndTooltip displayedRange(double range) {
        return new TextAndTooltip(ValueFormatsKt.asDistance$default((double)range, (boolean)false, (boolean)false, (int)0, (int)7, null), 0L, (Function2)ComposableLambdaKt.composableLambdaInstance((int)543829292, (boolean)true, (Object)new Function2<Composer, Integer, Unit>(range){
            final /* synthetic */ double $range;
            {
                this.$range = $range;
            }

            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public final void invoke(Composer $composer, int $changed) {
                if (($changed & 3) != 2 || !$composer.getSkipping()) {
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventStart((int)543829292, (int)$changed, (int)-1, (String)"theorycrafter.ui.fiteditor.displayedRange.<anonymous> (RangeColumn.kt:229)");
                    }
                    ValueWithDescription[] valueWithDescriptionArray = new ValueWithDescription[]{new ValueWithDescription(RangeColumnKt.access$asTooltipDistance(this.$range), "range")};
                    ValueWithDescriptionTableKt.ValueWithDescriptionTable(valueWithDescriptionArray, null, null, $composer, 0, 6);
                    if (ComposerKt.isTraceInProgress()) {
                        ComposerKt.traceEventEnd();
                    }
                } else {
                    $composer.skipToGroupEnd();
                }
            }
        }), 2, null);
    }

    private static final String asTooltipDistance(double $this$asTooltipDistance) {
        return ValueFormatsKt.asDistanceWithPrecision$default((double)$this$asTooltipDistance, (int)1, (boolean)false, (boolean)false, (int)6, null);
    }

    private static final String asTooltipChance(double $this$asTooltipChance) {
        return ValueFormatsKt.fractionAsPercentage$default((double)$this$asTooltipChance, (int)1, (boolean)false, (int)2, null);
    }

    private static final String asString(MissileRange $this$asString) {
        StringBuilder stringBuilder;
        int shortKm = (int)($this$asString.getShortRange() / (double)1000);
        int longKm = (int)Math.ceil($this$asString.getLongRange() / (double)1000);
        StringBuilder $this$asString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$asString_u24lambda_u242.append(shortKm);
        $this$asString_u24lambda_u242.append("\u2013");
        $this$asString_u24lambda_u242.append(longKm);
        $this$asString_u24lambda_u242.append("\u202f");
        $this$asString_u24lambda_u242.append("km");
        return stringBuilder.toString();
    }

    public static final /* synthetic */ List access$standardTooltipItems(ModuleOrDrone $receiver) {
        return RangeColumnKt.standardTooltipItems($receiver);
    }

    public static final /* synthetic */ String access$asTooltipDistance(double $receiver) {
        return RangeColumnKt.asTooltipDistance($receiver);
    }
}

