/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.ui;

import eve.data.ChargeType;
import eve.data.EveData;
import eve.data.ImplantType;
import eve.data.ShipType;
import eve.data.SubsystemType;
import eve.data.TacticalModeType;
import eve.data.TypeGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0004\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0007\u001a\u0013\u0010\u0003\u001a\u00020\u0002*\u00020\tR\u00020\b\u00a2\u0006\u0002\u0010\n\u001a\u0012\u0010\u0003\u001a\u00020\u0002*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u000f\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"COMMON_IMPLANT_NAME_PREFIXES", "", "", "shortName", "Leve/data/ImplantType;", "SHIP_SUBSTRING_ABBREVIATIONS", "Lkotlin/Pair;", "Leve/data/ShipType;", "Leve/data/EveData;", "Leve/data/TacticalModeType;", "(Leve/data/EveData;Leve/data/TacticalModeType;)Ljava/lang/String;", "Leve/data/SubsystemType;", "includeKind", "", "AMMO_SUBSTRING_ABBREVIATIONS", "Leve/data/ChargeType;", "Theorycrafter"})
public final class ShortNamesKt {
    @NotNull
    private static final List<String> COMMON_IMPLANT_NAME_PREFIXES;
    @NotNull
    private static final List<Pair<String, String>> SHIP_SUBSTRING_ABBREVIATIONS;
    @NotNull
    private static final List<Pair<String, String>> AMMO_SUBSTRING_ABBREVIATIONS;

    @NotNull
    public static final String shortName(@NotNull ImplantType $this$shortName) {
        Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"<this>");
        String name2 = $this$shortName.getName();
        for (String prefix : COMMON_IMPLANT_NAME_PREFIXES) {
            if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) continue;
            String string2 = name2.substring(prefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
        }
        return name2;
    }

    @NotNull
    public static final String shortName(@NotNull ShipType $this$shortName) {
        Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"<this>");
        String name2 = $this$shortName.getName();
        for (Pair<String, String> pair : SHIP_SUBSTRING_ABBREVIATIONS) {
            String substring = (String)pair.component1();
            String abbreviation = (String)pair.component2();
            if (!StringsKt.contains$default((CharSequence)name2, (CharSequence)substring, (boolean)false, (int)2, null)) continue;
            return StringsKt.replace$default((String)name2, (String)substring, (String)abbreviation, (boolean)false, (int)4, null);
        }
        return name2;
    }

    @NotNull
    public static final String shortName(@NotNull EveData $context_receiver_0, @NotNull TacticalModeType $this$shortName) {
        String string2;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
                TypeGroup shipGroup = $context_receiver_0.shipType($this$shortName.getShipId()).getGroup();
                if (!Intrinsics.areEqual((Object)shipGroup, (Object)$context_receiver_0.getGroups().getTacticalDestroyer())) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[$this$shortName.getKind().ordinal()]) {
                    case 1: {
                        string2 = "Defense";
                        break block11;
                    }
                    case 2: {
                        string2 = "Sharpshooter";
                        break block11;
                    }
                    case 3: {
                        string2 = "Propulsion";
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[$this$shortName.getKind().ordinal()]) {
                case 1: {
                    string2 = "Primary";
                    break;
                }
                case 2: {
                    string2 = "Secondary";
                    break;
                }
                case 3: {
                    string2 = "Tertiary";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string2;
    }

    @NotNull
    public static final String shortName(@NotNull SubsystemType $this$shortName, boolean includeKind) {
        Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"<this>");
        return StringsKt.substringAfter$default((String)$this$shortName.getName(), (String)(includeKind ? " " : "- "), null, (int)2, null);
    }

    @NotNull
    public static final String shortName(@NotNull ChargeType $this$shortName) {
        Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"<this>");
        for (Pair<String, String> pair : AMMO_SUBSTRING_ABBREVIATIONS) {
            String substring = (String)pair.component1();
            String abbreviation = (String)pair.component2();
            if (!StringsKt.startsWith$default((String)$this$shortName.getName(), (String)substring, (boolean)false, (int)2, null)) continue;
            String string2 = $this$shortName.getName().substring(substring.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return abbreviation + string2;
        }
        return $this$shortName.getName();
    }

    static {
        Object[] objectArray = new String[]{"Inherent Implants 'Noble'", "Inherent Implants 'Squire'", "Inherent Implants 'Lancer'", "Inherent Implants 'Highwall'", "Inherent Implants 'Yeti'", "Eifyr and Co. 'Gunslinger'", "Eifyr and Co. 'Rogue'", "Eifyr and Co. 'Alchemist'", "Zainou 'Deadeye'", "Zainou 'Gnome'", "Zainou 'Gypsy'", "Zainou 'Beancounter'", "Zainou 'Snapshot'", "Poteque 'Prospector'", "Black Market 'Valdimar'", "Inquest 'Eros'", "Inquest 'Hedone'", "Overmind 'Goliath'", "Overmind 'Hawkmoth'", "Creodron 'Bumblebee'", "Creodron 'Yellowjacket'", "Hardwiring - Zainou"};
        COMMON_IMPLANT_NAME_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Navy Issue", (Object)"NI"), TuplesKt.to((Object)"Fleet Issue", (Object)"FI"), TuplesKt.to((Object)"Caldari Navy", (Object)"CN"), TuplesKt.to((Object)"Federation Navy", (Object)"FN"), TuplesKt.to((Object)"Imperial Navy", (Object)"IN"), TuplesKt.to((Object)"Republic Fleet", (Object)"RF"), TuplesKt.to((Object)"Mark V", (Object)"V"), TuplesKt.to((Object)"Tribal Issue", (Object)"TI"), TuplesKt.to((Object)"Federate Issue", (Object)"FI"), TuplesKt.to((Object)"Imperial Issue", (Object)"II"), TuplesKt.to((Object)"State Issue", (Object)"SI"), TuplesKt.to((Object)"Quafe Ultra Edition", (Object)"QUE"), TuplesKt.to((Object)"Quafe Ultramarine Edition", (Object)"QUME"), TuplesKt.to((Object)"Amastris Edition", (Object)"AE"), TuplesKt.to((Object)"Emergency Responder", (Object)"ER")};
        SHIP_SUBSTRING_ABBREVIATIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Caldari Navy", (Object)"CN"), TuplesKt.to((Object)"Federation Navy", (Object)"FN"), TuplesKt.to((Object)"Imperial Navy", (Object)"IN"), TuplesKt.to((Object)"Republic Fleet", (Object)"RF"), TuplesKt.to((Object)"Dread Guristas", (Object)"DG"), TuplesKt.to((Object)"Arch Angel", (Object)"AA"), TuplesKt.to((Object)"Dark Blood", (Object)"DB"), TuplesKt.to((Object)"True Sansha", (Object)"TS")};
        AMMO_SUBSTRING_ABBREVIATIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TacticalModeType.Kind.values().length];
            try {
                nArray[TacticalModeType.Kind.DEFENSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TacticalModeType.Kind.SHARPSHOOTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TacticalModeType.Kind.PROPULSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

