/*
 * Decompiled with CFR 0.152.
 */
package theorycrafter.tournaments;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import eve.data.EveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import theorycrafter.tournaments.Composition;
import theorycrafter.tournaments.StoredComposition;
import theorycrafter.tournaments.TournamentDescriptor;
import theorycrafter.tournaments.TournamentRepository;
import theorycrafter.tournaments.TournamentRules;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\"\u001a\u00020#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160$J\u0016\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Ltheorycrafter/tournaments/Tournament;", "", "eveData", "Leve/data/EveData;", "descriptor", "Ltheorycrafter/tournaments/TournamentDescriptor;", "repository", "Ltheorycrafter/tournaments/TournamentRepository;", "<init>", "(Leve/data/EveData;Ltheorycrafter/tournaments/TournamentDescriptor;Ltheorycrafter/tournaments/TournamentRepository;)V", "getEveData", "()Leve/data/EveData;", "getDescriptor", "()Ltheorycrafter/tournaments/TournamentDescriptor;", "getRepository", "()Ltheorycrafter/tournaments/TournamentRepository;", "rules", "Ltheorycrafter/tournaments/TournamentRules;", "getRules", "()Ltheorycrafter/tournaments/TournamentRules;", "mutableCompositions", "", "Ltheorycrafter/tournaments/Composition;", "compositions", "", "getCompositions", "()Ljava/util/List;", "addEmptyComposition", "name", "", "addComposition", "composition", "Ltheorycrafter/tournaments/StoredComposition;", "duplicateComposition", "deleteCompositions", "", "", "moveComposition", "fromIndex", "", "toIndex", "Theorycrafter"})
@Stable
@SourceDebugExtension(value={"SMAP\nTournament.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tournament.kt\ntheorycrafter/tournaments/Tournament\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1557#2:176\n1628#2,3:177\n1628#2,3:180\n*S KotlinDebug\n*F\n+ 1 Tournament.kt\ntheorycrafter/tournaments/Tournament\n*L\n110#1:176\n110#1:177,3\n152#1:180,3\n*E\n"})
public final class Tournament {
    @NotNull
    private final EveData eveData;
    @NotNull
    private final TournamentDescriptor descriptor;
    @NotNull
    private final TournamentRepository repository;
    @NotNull
    private final TournamentRules rules;
    @NotNull
    private final List<Composition> mutableCompositions;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public Tournament(@NotNull EveData eveData, @NotNull TournamentDescriptor descriptor, @NotNull TournamentRepository repository) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)eveData, (String)"eveData");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.eveData = eveData;
        this.descriptor = descriptor;
        this.repository = repository;
        this.rules = (TournamentRules)this.descriptor.getRulesFactory().invoke((Object)this.eveData);
        Iterable iterable = this.repository.getCompositions();
        Tournament tournament2 = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StoredComposition storedComposition = (StoredComposition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Composition.Companion.fromStored(this, (StoredComposition)it));
        }
        tournament2.mutableCompositions = (List)SnapshotStateKt.toMutableStateList((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public final EveData getEveData() {
        return this.eveData;
    }

    @NotNull
    public final TournamentDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final TournamentRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final TournamentRules getRules() {
        return this.rules;
    }

    @NotNull
    public final List<Composition> getCompositions() {
        return this.mutableCompositions;
    }

    @NotNull
    public final Composition addEmptyComposition(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.addComposition(new StoredComposition(null, name2, CollectionsKt.emptyList(), null, 9, null));
    }

    @NotNull
    public final Composition addComposition(@NotNull StoredComposition composition) {
        Composition composition2;
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        this.repository.addComposition(composition);
        Composition it = composition2 = Composition.Companion.fromStored(this, composition);
        boolean bl = false;
        this.mutableCompositions.add(it);
        return composition2;
    }

    @NotNull
    public final Composition duplicateComposition(@NotNull Composition composition, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)composition, (String)"composition");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.addComposition(composition.toStoredCompositionDuplicate(name2));
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteCompositions(@NotNull Collection<Composition> compositions) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(compositions, (String)"compositions");
        Iterable iterable = compositions;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Composition composition = (Composition)item$iv;
            void var10_9 = destination$iv;
            boolean bl = false;
            var10_9.add(it.getId());
        }
        Set deletedIds = (Set)destination$iv;
        this.repository.deleteCompositions(deletedIds);
        Iterator<Composition> iterator = this.mutableCompositions.iterator();
        while (iterator.hasNext()) {
            Composition comp = iterator.next();
            if (!deletedIds.contains(comp.getId())) continue;
            comp.setDeleted(true);
            iterator.remove();
        }
    }

    public final void moveComposition(int fromIndex, int toIndex) {
        Composition composition = this.mutableCompositions.remove(fromIndex);
        this.mutableCompositions.add(toIndex, composition);
    }
}

