/*
 * Decompiled with CFR 0.152.
 */
package eve.data;

import androidx.compose.runtime.internal.StabilityInferred;
import eve.data.Attribute;
import java.math.BigDecimal;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001d\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u00020\b2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J4\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c7\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010'\u001a\u00020\u0003H\u00d7\u0001J\t\u0010(\u001a\u00020)H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R#\u0010\u0019\u001a\n \u0014*\u0004\u0018\u00010\u00130\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001a\u0010\u0016\u00a8\u0006*"}, d2={"Leve/data/AttributeMutation;", "", "attributeId", "", "factorRange", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "highIsGood", "", "<init>", "(ILkotlin/ranges/ClosedFloatingPointRange;Ljava/lang/Boolean;)V", "getAttributeId", "()I", "getFactorRange", "()Lkotlin/ranges/ClosedFloatingPointRange;", "getHighIsGood", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "factorRangeStartDecimal", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "getFactorRangeStartDecimal", "()Ljava/math/BigDecimal;", "factorRangeStartDecimal$delegate", "Lkotlin/Lazy;", "factorRangeEndInclusiveDecimal", "getFactorRangeEndInclusiveDecimal", "factorRangeEndInclusiveDecimal$delegate", "attributeValueRange", "baseValue", "attribute", "Leve/data/Attribute;", "component1", "component2", "component3", "copy", "(ILkotlin/ranges/ClosedFloatingPointRange;Ljava/lang/Boolean;)Leve/data/AttributeMutation;", "equals", "other", "hashCode", "toString", "", "EveData"})
@StabilityInferred(parameters=0)
public final class AttributeMutation {
    private final int attributeId;
    @NotNull
    private final ClosedFloatingPointRange<Double> factorRange;
    @Nullable
    private final Boolean highIsGood;
    @NotNull
    private final Lazy factorRangeStartDecimal$delegate;
    @NotNull
    private final Lazy factorRangeEndInclusiveDecimal$delegate;
    public static final int $stable = 8;

    public AttributeMutation(int attributeId, @NotNull ClosedFloatingPointRange<Double> factorRange, @Nullable Boolean highIsGood) {
        Intrinsics.checkNotNullParameter(factorRange, (String)"factorRange");
        this.attributeId = attributeId;
        this.factorRange = factorRange;
        this.highIsGood = highIsGood;
        this.factorRangeStartDecimal$delegate = LazyKt.lazy(() -> AttributeMutation.factorRangeStartDecimal_delegate$lambda$0(this));
        this.factorRangeEndInclusiveDecimal$delegate = LazyKt.lazy(() -> AttributeMutation.factorRangeEndInclusiveDecimal_delegate$lambda$1(this));
    }

    public final int getAttributeId() {
        return this.attributeId;
    }

    @NotNull
    public final ClosedFloatingPointRange<Double> getFactorRange() {
        return this.factorRange;
    }

    @Nullable
    public final Boolean getHighIsGood() {
        return this.highIsGood;
    }

    private final BigDecimal getFactorRangeStartDecimal() {
        Lazy lazy = this.factorRangeStartDecimal$delegate;
        return (BigDecimal)lazy.getValue();
    }

    private final BigDecimal getFactorRangeEndInclusiveDecimal() {
        Lazy lazy = this.factorRangeEndInclusiveDecimal$delegate;
        return (BigDecimal)lazy.getValue();
    }

    @NotNull
    public final ClosedFloatingPointRange<Double> attributeValueRange(double baseValue) {
        BigDecimal baseValueDecimal = BigDecimal.valueOf(baseValue);
        Intrinsics.checkNotNull((Object)baseValueDecimal);
        BigDecimal bigDecimal = baseValueDecimal;
        BigDecimal bigDecimal2 = this.getFactorRangeEndInclusiveDecimal();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"<get-factorRangeEndInclusiveDecimal>(...)");
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
        double v2 = bigDecimal3.doubleValue();
        BigDecimal bigDecimal4 = baseValueDecimal;
        BigDecimal bigDecimal5 = this.getFactorRangeStartDecimal();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"<get-factorRangeStartDecimal>(...)");
        BigDecimal bigDecimal6 = bigDecimal4.multiply(bigDecimal5);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"multiply(...)");
        double v1 = bigDecimal6.doubleValue();
        return baseValue >= 0.0 ? RangesKt.rangeTo((double)v1, (double)v2) : RangesKt.rangeTo((double)v2, (double)v1);
    }

    public final boolean highIsGood(@NotNull Attribute<?> attribute2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(attribute2, (String)"attribute");
        if (attribute2.getId() != this.attributeId) {
            throw new IllegalArgumentException("Wrong attribute given");
        }
        Boolean bl2 = this.highIsGood;
        if (bl2 != null) {
            bl = bl2;
        } else {
            Boolean bl3 = attribute2.getHighIsGood();
            if (bl3 != null) {
                bl = bl3;
            } else {
                throw new IllegalStateException(("Unknown whether attribute " + attribute2 + " high is good").toString());
            }
        }
        return bl;
    }

    public final int component1() {
        return this.attributeId;
    }

    @NotNull
    public final ClosedFloatingPointRange<Double> component2() {
        return this.factorRange;
    }

    @Nullable
    public final Boolean component3() {
        return this.highIsGood;
    }

    @NotNull
    public final AttributeMutation copy(int attributeId, @NotNull ClosedFloatingPointRange<Double> factorRange, @Nullable Boolean highIsGood) {
        Intrinsics.checkNotNullParameter(factorRange, (String)"factorRange");
        return new AttributeMutation(attributeId, factorRange, highIsGood);
    }

    public static /* synthetic */ AttributeMutation copy$default(AttributeMutation attributeMutation, int n, ClosedFloatingPointRange closedFloatingPointRange, Boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = attributeMutation.attributeId;
        }
        if ((n2 & 2) != 0) {
            closedFloatingPointRange = attributeMutation.factorRange;
        }
        if ((n2 & 4) != 0) {
            bl = attributeMutation.highIsGood;
        }
        return attributeMutation.copy(n, closedFloatingPointRange, bl);
    }

    @NotNull
    public String toString() {
        return "AttributeMutation(attributeId=" + this.attributeId + ", factorRange=" + this.factorRange + ", highIsGood=" + this.highIsGood + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.attributeId);
        result = result * 31 + this.factorRange.hashCode();
        result = result * 31 + (this.highIsGood == null ? 0 : ((Object)this.highIsGood).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeMutation)) {
            return false;
        }
        AttributeMutation attributeMutation = (AttributeMutation)other;
        if (this.attributeId != attributeMutation.attributeId) {
            return false;
        }
        if (!Intrinsics.areEqual(this.factorRange, attributeMutation.factorRange)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.highIsGood, (Object)attributeMutation.highIsGood);
    }

    private static final BigDecimal factorRangeStartDecimal_delegate$lambda$0(AttributeMutation this$0) {
        return BigDecimal.valueOf(((Number)((Object)this$0.factorRange.getStart())).doubleValue());
    }

    private static final BigDecimal factorRangeEndInclusiveDecimal_delegate$lambda$1(AttributeMutation this$0) {
        return BigDecimal.valueOf(((Number)((Object)this$0.factorRange.getEndInclusive())).doubleValue());
    }
}

